/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.licenses;

import com.atlassian.rm.common.bridges.jira.license.LicenseData;
import com.atlassian.rm.common.bridges.jira.license.PluginLicenseServiceBridge;
import com.atlassian.rm.common.bridges.jira.license.PluginLicenseServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.license.ProductLicenseServiceBridge;
import com.atlassian.rm.common.bridges.jira.license.ProductLicenseServiceBridgeProxy;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.extensions.licenses.LicenseExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraLicenseExtension
implements LicenseExtension {
    private final FeatureExtension featureExtension;
    private final PluginLicenseServiceBridgeProxy pluginLicenseServiceBridgeProxy;
    private final ProductLicenseServiceBridgeProxy productLicenseServiceBridgeProxy;

    @Autowired
    public JiraLicenseExtension(FeatureExtension featureExtension, PluginLicenseServiceBridgeProxy pluginLicenseServiceBridgeProxy, ProductLicenseServiceBridgeProxy productLicenseServiceBridgeProxy) {
        this.featureExtension = featureExtension;
        this.pluginLicenseServiceBridgeProxy = pluginLicenseServiceBridgeProxy;
        this.productLicenseServiceBridgeProxy = productLicenseServiceBridgeProxy;
    }

    @Override
    public LicenseData getLicenseData() {
        LicenseData productLicenseData = ((ProductLicenseServiceBridge)this.productLicenseServiceBridgeProxy.get()).getLicenseData();
        boolean isDcBundlingEnabled = this.featureExtension.isDcBundlingEnabled();
        if (isDcBundlingEnabled && productLicenseData.isValid()) {
            return productLicenseData;
        }
        return ((PluginLicenseServiceBridge)this.pluginLicenseServiceBridgeProxy.get()).getLicenseData(productLicenseData.isValid(), isDcBundlingEnabled);
    }
}

