/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.JiraAnalyzer;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.query.lucene.parsing.LuceneQueryParserFactory;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.index.IndexServiceBridge;
import com.atlassian.rm.common.bridges.lucene.Document;
import com.atlassian.rm.common.bridges.lucene.Document33;
import com.atlassian.rm.common.bridges.lucene.Field;
import com.atlassian.rm.common.bridges.lucene.Field33;
import com.atlassian.rm.common.bridges.lucene.FieldCache;
import com.atlassian.rm.common.bridges.lucene.FieldCache33;
import com.atlassian.rm.common.bridges.lucene.IndexReader;
import com.atlassian.rm.common.bridges.lucene.IndexStore;
import com.atlassian.rm.common.bridges.lucene.IndexStore33;
import com.atlassian.rm.common.bridges.lucene.MultiIndexReader;
import com.atlassian.rm.common.bridges.lucene.MultiIndexReader33;
import com.atlassian.rm.common.bridges.lucene.NumberValueConverter;
import com.atlassian.rm.common.bridges.lucene.NumberValueConverter33;
import com.atlassian.rm.common.bridges.lucene.Query;
import com.atlassian.rm.common.bridges.lucene.Query33;
import com.atlassian.rm.common.bridges.lucene.QueryParser;
import com.atlassian.rm.common.bridges.lucene.QueryParser33;
import java.util.Collection;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.index.IndexServiceBridge710")
@SupportedVersions(maxExclusive="8.0")
public class IndexServiceBridge710
implements IndexServiceBridge {
    @Override
    public IndexStore.Factory getIndexStoryFactory() {
        return new IndexStore33.Factory(JiraAnalyzer.ANALYZER_FOR_INDEXING);
    }

    @Override
    public Document.Factory getDocumentFactory() {
        return new Document33.Factory();
    }

    @Override
    public Field.Factory getFieldFactory() {
        return new Field33.Factory();
    }

    @Override
    public Query.Factory getQueryFactory() {
        return new Query33.Factory();
    }

    @Override
    public Query.Builder getQueryBuilder() {
        return new Query33.Builder();
    }

    @Override
    public MultiIndexReader makeMultiIndexReader(Collection<IndexReader> subReaders) {
        return new MultiIndexReader33(subReaders);
    }

    @Override
    public FieldCache getFieldCache() {
        return new FieldCache33();
    }

    @Override
    public QueryParser getQueryParserFor(String fieldName) {
        LuceneQueryParserFactory queryParserFactory = (LuceneQueryParserFactory)ComponentAccessor.getComponent(LuceneQueryParserFactory.class);
        return new QueryParser33(queryParserFactory.createParserFor(fieldName));
    }

    @Override
    public QueryFactoryResult toQueryFactoryResult(Query query) {
        return new QueryFactoryResult(((Query33)query).getLuceneValue());
    }

    @Override
    public NumberValueConverter.Factory getNumberValueConverterFactory() {
        return new NumberValueConverter33.Factory();
    }

    @Override
    public Query createRangeQuery(String name, @Nullable Number lower, @Nullable Number upper, boolean includeLower, boolean includeUpper) {
        if ("resolutiondate".equals(name)) {
            lower = this.divide(lower, 1000L);
            upper = this.divide(upper, 1000L);
        }
        return this.getQueryFactory().createTermRangeQuery(name, lower, upper, includeLower, includeUpper);
    }

    private Number divide(@Nullable Number numerator, long denominator) {
        if (numerator == null) {
            return null;
        }
        if (numerator instanceof Long) {
            return numerator.longValue() / denominator;
        }
        throw new UnsupportedOperationException(String.format("Division for '%s' is not currently supported!", numerator.getClass()));
    }
}

