/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.priority;

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.priority.IssuePrioritySchemeData;
import com.atlassian.rm.common.bridges.jira.issue.priority.IssuePrioritySchemeServiceBridge;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.priority.IssuePrioritySchemeServiceBridge710")
@SupportedVersions(all=true)
public class IssuePrioritySchemeServiceBridge710
implements IssuePrioritySchemeServiceBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssuePrioritySchemeServiceBridge710.class);
    private final PrioritySchemeManager prioritySchemeManager;
    private final PriorityManager priorityManager;

    @Autowired
    public IssuePrioritySchemeServiceBridge710(PrioritySchemeManager prioritySchemeManager, PriorityManager priorityManager) {
        this.prioritySchemeManager = prioritySchemeManager;
        this.priorityManager = priorityManager;
    }

    @Override
    public IssuePrioritySchemeData getIssuePriorityScheme(Project project) {
        List<String> priorityIds;
        String defaultPriority;
        FieldConfigScheme scheme = this.prioritySchemeManager.getScheme(project);
        if (scheme == null) {
            LOGGER.warn("No priority scheme for project: " + project.getKey());
            return null;
        }
        if (scheme.isGlobal()) {
            defaultPriority = this.prioritySchemeManager.getDefaultOption(IssueContext.GLOBAL);
            List priorities = this.priorityManager.getPriorities();
            priorityIds = priorities.stream().map(IssueConstant::getId).collect(Collectors.toList());
        } else {
            FieldConfig field = scheme.getOneAndOnlyConfig();
            defaultPriority = this.prioritySchemeManager.getDefaultOption(field);
            priorityIds = this.prioritySchemeManager.getOptions(field);
        }
        return new IssuePrioritySchemeData(String.valueOf(scheme.getId()), priorityIds, defaultPriority);
    }
}

