/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.properties;

import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.properties.IssuePropertyServiceBridge;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.properties.IssuePropertyServiceBridge80")
@SupportedVersions(minInclusive="8.0", maxExclusive="8.1")
public class IssuePropertyServiceBridge80
implements IssuePropertyServiceBridge {
    private final JiraAuthenticationContext authenticationContext;
    private final IssuePropertyService issuePropertyService;

    @Autowired
    public IssuePropertyServiceBridge80(JiraAuthenticationContext authenticationContext, IssuePropertyService issuePropertyService) {
        this.authenticationContext = authenticationContext;
        this.issuePropertyService = issuePropertyService;
    }

    @Override
    public Optional<String> getProperty(long issueId, String propertyKey, boolean skipPermissionChecks) {
        EntityPropertyService.PropertyResult result = skipPermissionChecks ? this.issuePropertyService.getProperty(this.authenticationContext.getLoggedInUser(), Long.valueOf(issueId), propertyKey, this.skipPermissionChecks()) : this.issuePropertyService.getProperty(this.authenticationContext.getLoggedInUser(), Long.valueOf(issueId), propertyKey);
        return result.getEntityProperty().isEmpty() ? Optional.absent() : Optional.of((Object)((EntityProperty)result.getEntityProperty().get()).getValue());
    }

    @Override
    public void setProperty(long issueId, String propertyKey, String propertyValue, boolean skipPermissionChecks) {
        EntityPropertyService.SetPropertyValidationResult validationResult = this.validateSetProperty(issueId, propertyKey, propertyValue, skipPermissionChecks);
        this.issuePropertyService.setProperty(this.authenticationContext.getLoggedInUser(), validationResult);
    }

    @VisibleForTesting
    EntityPropertyService.SetPropertyValidationResult validateSetProperty(long issueId, String propertyKey, String propertyValue, boolean skipPermissionChecks) {
        EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput(propertyValue, propertyKey);
        EntityPropertyService.SetPropertyValidationResult validationResult = skipPermissionChecks ? this.issuePropertyService.validateSetProperty(this.authenticationContext.getLoggedInUser(), Long.valueOf(issueId), propertyInput, this.skipPermissionChecks()) : this.issuePropertyService.validateSetProperty(this.authenticationContext.getLoggedInUser(), Long.valueOf(issueId), propertyInput);
        return validationResult;
    }

    @VisibleForTesting
    EntityPropertyOptions skipPermissionChecks() {
        return new EntityPropertyOptions.Builder().skipPermissionChecks().build();
    }
}

