/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.user;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.user.UserServiceBridge;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.user.UserServiceBridge710")
@SupportedVersions(all=true)
public class UserServiceBridge710
implements UserServiceBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceBridge710.class);
    private final UserService userService;
    private final UserUtil userUtil;
    private final GroupManager groupManager;
    private final ApplicationRoleManager applicationRoleManager;
    private final UserKeyService userKeyService;

    @Autowired
    public UserServiceBridge710(UserService userService, UserUtil userUtil, GroupManager groupManager, ApplicationRoleManager applicationRoleManager, UserKeyService userKeyService) {
        this.userService = userService;
        this.userUtil = userUtil;
        this.groupManager = groupManager;
        this.applicationRoleManager = applicationRoleManager;
        this.userKeyService = userKeyService;
    }

    @Override
    public void createUserNoNotification(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        ApplicationUser user = this.userService.createUserNoNotification(result);
        for (Group defaultGroup : this.applicationRoleManager.getDefaultGroups(ApplicationKeys.CORE)) {
            try {
                this.groupManager.addUserToGroup(user, defaultGroup);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to add user to group. userId={}. groupName={}", new Object[]{user.getId(), defaultGroup.getName(), e});
            }
        }
    }

    @Override
    public UserService.CreateUserValidationResult validateCreateUserForSetup(ApplicationUser loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        return this.userService.validateCreateUserForSetup(loggedInUser, username, password, confirmPassword, email, fullname);
    }

    @Override
    public UserService.DeleteUserValidationResult validateDeleteUser(ApplicationUser loggedInUser, String username) {
        return this.userService.validateDeleteUser(loggedInUser, username);
    }

    @Override
    public void removeUser(ApplicationUser loggedInUser, UserService.DeleteUserValidationResult result) {
        this.userService.removeUser(loggedInUser, result);
    }

    @Override
    public void addUserToGroup(ApplicationUser user, String group) throws AddException, PermissionException {
        Group groupObject = this.groupManager.getGroup(group);
        if (groupObject != null) {
            this.userUtil.addUserToGroup(groupObject, user);
        }
    }

    @Override
    public void removeUserFromGroup(ApplicationUser user, String group) throws RemoveException, PermissionException {
        Group groupObject = this.groupManager.getGroup(group);
        if (groupObject != null) {
            this.userUtil.removeUserFromGroup(groupObject, user);
        }
    }

    @Override
    public Optional<ApplicationUser> getSomeSysAdmin() {
        return Optional.fromNullable((Object)Iterables.getFirst((Iterable)this.userUtil.getJiraSystemAdministrators(), null));
    }

    @Override
    public Optional<String> getUserKeyForUsername(String username) {
        return Optional.fromNullable((Object)this.userKeyService.getKeyForUsername(username));
    }
}

