/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IAbility;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOAbility;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.AbilitySQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbilityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsAbilityPersistence
extends AOEntityPersistence<IAbility, AOAbility>
implements PortfolioAbilityPersistence {
    private final AbilitySQL abilitySQL;
    private final PortfolioPersonPersistence personPersistence;

    @Autowired
    public PortfolioActiveObjectsAbilityPersistence(ActiveObjectsUtilities utils, PortfolioPersonPersistence personPersistence) {
        super(utils, IAbility.class, AOAbility.class);
        this.personPersistence = personPersistence;
        this.abilitySQL = new AbilitySQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioAbilityPersistence.class;
    }

    @Override
    protected void transform(IAbility source, AOAbility target) throws Exception {
        TransformerUtils.transformVersionable(source, target);
        target.setAOPerson(source.getPerson() != null ? (AOPerson)this.personPersistence.get(source.getPerson().getId()) : null);
        if (source.getTargetId() != null) {
            target.setTargetId(source.getTargetId());
        }
        if (source.getTargetType() != null) {
            target.setTargetType(source.getTargetType());
        }
        target.setAbilityValue(source.getAbilityValue());
    }

    @Override
    public void setAbility(String personId, String targetType, String targetId, Double value) throws SQLException {
        this.abilitySQL.setAbility(personId, targetType, targetId, value);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOAbility.class, "t").withTable(AOPerson.class, "h1").select().raw("t.*").from("t").leftJoin().table("h1").on().col("t", "aoPerson").eq().colId("h1").where().col("h1", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().colId("t");
        }
    }

    @Override
    public IKeyResolver getForeignKeyResolver(String method) {
        if ("getTargetId".equals(method)) {
            return new AbilityTargetForeignKeyResolver();
        }
        return super.getForeignKeyResolver(method);
    }

    private class AbilityTargetForeignKeyResolver
    implements IKeyResolver {
        private AbilityTargetForeignKeyResolver() {
        }

        @Override
        public Class<?> resolve(String dependency) {
            if ("skill".equals(dependency)) {
                return AOSkill.class;
            }
            if ("stage".equals(dependency)) {
                return AOStage.class;
            }
            throw new RuntimeException("Cannot create foreign key resolver for ability target type '" + dependency + "'.");
        }

        @Override
        public String getPrefix(String dependency) {
            return null;
        }
    }
}

