/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.CorruptIndexException;
import com.atlassian.rm.common.bridges.lucene.FieldCache;
import com.atlassian.rm.common.bridges.lucene.IndexReader;
import com.atlassian.rm.common.bridges.lucene.IndexReader73;
import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;

public class FieldCache73
implements FieldCache {
    @Override
    public StringIndex getStringIndex(IndexReader reader, String field) throws IOException {
        try {
            LeafReader leafReader = (LeafReader)((IndexReader73)reader).getLuceneValue();
            return new StringIndex(leafReader, DocValues.getSorted((LeafReader)leafReader, (String)field));
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }

    static class StringIndex
    implements FieldCache.StringIndex {
        private final LeafReader leafReader;
        private final SortedDocValues docValues;

        StringIndex(LeafReader leafReader, SortedDocValues docValues) {
            this.leafReader = leafReader;
            this.docValues = docValues;
        }

        @Override
        public int order(int index) {
            if (index < 0 || index >= this.leafReader.maxDoc()) {
                throw new IndexOutOfBoundsException();
            }
            try {
                return this.docValues.advanceExact(index) ? this.docValues.ordValue() + 1 : 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int orderSize() {
            return this.leafReader.maxDoc();
        }

        @Override
        public String lookup(int index) {
            if (index == 0) {
                return null;
            }
            try {
                return this.docValues.lookupOrd(index - 1).utf8ToString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int binarySearchLookup(String key) {
            if (key == null) {
                return 0;
            }
            try {
                int term = this.docValues.lookupTerm(new BytesRef((CharSequence)key));
                return term < 0 ? term - 1 : term + 1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

