/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.AssignmentResourceWrapper;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.BoundActivitySchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.DefaultStageTaskProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.IBoundAssignmentProblemCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.IGroupActivitySchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.StageTaskProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceCostCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.MutableResourceCostCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IStageTask;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class TaskAssignmentIgnoringAssignmentProblemCreator
implements IBoundAssignmentProblemCreator {
    private final IMutableResourceCostCalculator costCalculator;

    TaskAssignmentIgnoringAssignmentProblemCreator() {
        this(new MutableResourceCostCalculator());
    }

    TaskAssignmentIgnoringAssignmentProblemCreator(MutableResourceCostCalculator mutableResourceCostCalculator) {
        this.costCalculator = mutableResourceCostCalculator;
    }

    @Override
    public Optional<BoundAssignmentProblem> tryCreate(IGroupActivitySchedulingProblem problem, int timeLimit) {
        Optional<IIntegerInterval> interval = problem.tryCreateSolutionInterval(timeLimit);
        if (!interval.isPresent()) {
            return Optional.absent();
        }
        Set<AssignmentResource> skillRelevantResources = this.createProblemResources(problem);
        Optional<List<StageTaskProblem>> stageTasks = TaskAssignmentIgnoringAssignmentProblemCreator.createStageTaskProblems(problem, skillRelevantResources);
        if (!stageTasks.isPresent()) {
            return Optional.absent();
        }
        BoundActivitySchedulingProblem instance = new BoundActivitySchedulingProblem((IIntegerInterval)interval.get(), problem.getResourceGroup().isStrictStageDivision(), (List)stageTasks.get(), problem.getOverallDemand(), skillRelevantResources, TaskAssignmentIgnoringAssignmentProblemCreator.safelyCalculateCombinedCombinationCount((Iterable)stageTasks.get()));
        return Optional.of((Object)instance);
    }

    private static Optional<List<StageTaskProblem>> createStageTaskProblems(IGroupActivitySchedulingProblem problem, Set<AssignmentResource> skillRelevantResources) {
        ArrayList stageTasks = Lists.newArrayList();
        for (IStageTask subTask : problem.getStageTasks()) {
            Set<AssignmentResource> subTaskResources = subTask.getAssignmentRestriction().filterResources(skillRelevantResources);
            if (subTaskResources.isEmpty()) {
                return Optional.absent();
            }
            stageTasks.add(new DefaultStageTaskProblem(subTask.getId(), subTask.getPositiveTypeAmounts(), subTaskResources, 1));
        }
        if (!problem.getActivity().getPositiveTypeAmounts().isEmpty()) {
            stageTasks.add(new DefaultStageTaskProblem(problem.getActivity().getId(), problem.getActivity().getPositiveTypeAmounts(), problem.getAssignmentRestriction().filterResources(skillRelevantResources), problem.getMaxResources()));
        }
        return Optional.of((Object)stageTasks);
    }

    private Set<AssignmentResource> createProblemResources(IGroupActivitySchedulingProblem problem) {
        HashSet assignmentResources = Sets.newHashSetWithExpectedSize((int)problem.getMutableResources().size());
        IMutableResourceGroup workSlotsDefinition = problem.getResourceGroup();
        for (IMutableResource resource : problem.getMutableResources()) {
            if (Sets.intersection(problem.getOverallDemand().keySet(), resource.getResourceTypes()).isEmpty()) continue;
            AssignmentResourceWrapper mathResource = AssignmentResourceWrapper.createInstance(workSlotsDefinition, resource, this.costCalculator.calculateWeight(resource, problem.getProjectStatistics()));
            assignmentResources.add(mathResource);
        }
        return assignmentResources;
    }

    private static int safelyCalculateCombinedCombinationCount(Iterable<StageTaskProblem> subProblems) {
        int product = 1;
        for (StageTaskProblem subProblem : subProblems) {
            try {
                product = IntMath.checkedMultiply((int)product, (int)subProblem.getCombinationCount());
            }
            catch (ArithmeticException e) {
                return Integer.MAX_VALUE;
            }
        }
        return product;
    }
}

