/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand;

import com.radiantminds.roadmap.common.data.generator.IPlanGeneratorConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.IRandomizedPlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.PlanConfigurationCreator;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.RandomizedBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.settings.IRandomizedSettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.settings.RandomizedSettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.teams.RandomizedTeamsConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.time.IRandomizedTimePlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.time.RandomizedTimePlanConfiguration;
import java.util.Random;

public class RandomizedPlanConfiguration
implements IRandomizedPlanConfiguration {
    private final IRandomizedSettingsConfiguration settingsConfiguration;
    private final RandomizedTeamsConfiguration teamsConfiguration;
    private final IRandomizedBacklogConfiguration backlogConfiguration;
    private final IRandomizedTimePlanConfiguration timePlanConfiguration;

    protected RandomizedPlanConfiguration(IRandomizedSettingsConfiguration settingsConfiguration, RandomizedTeamsConfiguration teamsConfiguration, IRandomizedBacklogConfiguration backlogConfiguration, IRandomizedTimePlanConfiguration timePlanConfiguration) {
        this.settingsConfiguration = settingsConfiguration;
        this.teamsConfiguration = teamsConfiguration;
        this.backlogConfiguration = backlogConfiguration;
        this.timePlanConfiguration = timePlanConfiguration;
    }

    @Override
    public IRandomizedSettingsConfiguration getSettingsConfiguration() {
        return this.settingsConfiguration;
    }

    @Override
    public RandomizedTeamsConfiguration getTeamsConfiguration() {
        return this.teamsConfiguration;
    }

    @Override
    public IRandomizedBacklogConfiguration getBacklogConfiguration() {
        return this.backlogConfiguration;
    }

    @Override
    public IRandomizedTimePlanConfiguration getTimePlanConfiguration() {
        return this.timePlanConfiguration;
    }

    @Override
    public IPlanGeneratorConfiguration toPlanConfiguration() {
        PlanConfigurationCreator planConfigurationCreator = new PlanConfigurationCreator();
        return planConfigurationCreator.createconfiguration(this, new Random());
    }

    public static class Builder {
        private IRandomizedSettingsConfiguration settingsConfiguration = new RandomizedSettingsConfiguration.Builder().build();
        private RandomizedTeamsConfiguration teamsConfiguration = new RandomizedTeamsConfiguration.Builder().build();
        private IRandomizedBacklogConfiguration backlogConfiguration = new RandomizedBacklogConfiguration.Builder().build();
        private IRandomizedTimePlanConfiguration timePlanConfiguration = new RandomizedTimePlanConfiguration.Builder().build();

        public Builder withBacklogConfiguration(IRandomizedBacklogConfiguration backlogConfiguration) {
            this.backlogConfiguration = backlogConfiguration;
            return this;
        }

        public Builder withTimePlanConfiguration(IRandomizedTimePlanConfiguration timePlanConfiguration) {
            this.timePlanConfiguration = timePlanConfiguration;
            return this;
        }

        public Builder withSettingsConfiguration(IRandomizedSettingsConfiguration settingsConfiguration) {
            this.settingsConfiguration = settingsConfiguration;
            return this;
        }

        public Builder withTeamsConfiguration(RandomizedTeamsConfiguration teamsConfiguration) {
            this.teamsConfiguration = teamsConfiguration;
            return this;
        }

        public IRandomizedPlanConfiguration build() {
            return new RandomizedPlanConfiguration(this.settingsConfiguration, this.teamsConfiguration, this.backlogConfiguration, this.timePlanConfiguration);
        }
    }
}

