/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.move;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.PortfolioMoveWorkItemPersistency;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.WorkItemMoveResult;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.common.RestWorkItemMoveData;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.services.workitems.move.WorkItemMoveRequest;
import java.sql.SQLException;
import java.util.Set;
import javax.ws.rs.core.Response;

public interface WorkItemMoveServiceHandler {
    public static final String MSG_ITEM_NOT_MOVABLE = "item-type-cannot-move";

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Implicit)
    public Response moveToAndRank(EntityContext<IWorkItem> var1, WorkItemMoveRequest var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Implicit)
    public Response moveTo(EntityContext<IWorkItem> var1, WorkItemMoveRequest var2) throws Exception;

    public static class Impl
    implements WorkItemMoveServiceHandler {
        private final PortfolioMoveWorkItemPersistency moveWorkItemPersistency;
        private final PortfolioWorkItemPersistence workItemPersistence;

        public Impl(PortfolioWorkItemPersistence workItemPersistence, PortfolioMoveWorkItemPersistency moveWorkItemPersistency) {
            this.moveWorkItemPersistency = moveWorkItemPersistency;
            this.workItemPersistence = workItemPersistence;
        }

        @Override
        public Response moveToAndRank(EntityContext<IWorkItem> entityContext, WorkItemMoveRequest moveRequest) throws Exception {
            return this.moveAndRankInternal(entityContext, moveRequest);
        }

        @Override
        public Response moveTo(EntityContext<IWorkItem> entityContext, WorkItemMoveRequest request) throws Exception {
            return this.moveToAndRank(entityContext, request);
        }

        private Response moveAndRankInternal(EntityContext<IWorkItem> entityContext, WorkItemMoveRequest moveRequest) throws Exception {
            IWorkItem workItem = entityContext.getEntity();
            Optional<String> newParentDbId = this.getDbId(moveRequest.getNewParentId());
            if (newParentDbId.isPresent() && !this.workItemPersistence.exists((String)newParentDbId.get())) {
                return ResponseBuilder.badRequest(RestMessaging.entityNotFound());
            }
            if (!workItem.canHaveParent()) {
                return ResponseBuilder.badRequest(RestMessaging.error(WorkItemMoveServiceHandler.MSG_ITEM_NOT_MOVABLE));
            }
            WorkItemMoveResult operationResult = this.moveWorkItemPersistency.moveWorkItem(workItem, (String)newParentDbId.orNull(), (RestRank)moveRequest.getRank().orNull(), (Set)moveRequest.getInheritanceRestriction().orNull());
            ModificationResult result = this.getModificationResult(operationResult);
            return entityContext.ok(result);
        }

        private Optional<String> getDbId(String id) {
            if ("-1".equals(id)) {
                return Optional.absent();
            }
            return Optional.fromNullable((Object)id);
        }

        private ModificationResult getModificationResult(WorkItemMoveResult result) throws SQLException {
            ModificationResult restResult = new ModificationResult();
            restResult.setData(RestWorkItemMoveData.createFrom(result));
            return restResult;
        }
    }
}

