/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.atlassian.rm.jpo.scheduling.util.function.BoundDiscreteBooleanFunction;
import com.atlassian.rm.jpo.scheduling.util.function.MutableBoundBooleanFunction;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.IntervalUtils;
import java.util.List;

class PresenceFunctionCreator {
    private final ITimeTransformer timeTransformer;

    public PresenceFunctionCreator(ITimeTransformer timeTransformer) {
        this.timeTransformer = timeTransformer;
    }

    BoundDiscreteBooleanFunction createPresenceFunction(List<? extends SchedulingInterval> boundedPresenceIntervals, List<? extends SchedulingInterval> absenceIntervals) {
        List<? extends SchedulingInterval> filteredAbsenceIntervals = IntervalUtils.filterValidTimelyIntervals(absenceIntervals, this.timeTransformer.getInstant(0));
        int start = IntervalUtils.getNullSafeEarliestStartTimeStep(boundedPresenceIntervals, this.timeTransformer);
        int end = this.getNullSafeLatestEndTimeStep(boundedPresenceIntervals);
        MutableBoundBooleanFunction function = MutableBoundBooleanFunction.create(start, end, false);
        for (SchedulingInterval schedulingInterval : boundedPresenceIntervals) {
            int presenceStart = IntervalUtils.getNullSafeStartTime(schedulingInterval, this.timeTransformer);
            int presenceEnd = this.getEndTimeStep(schedulingInterval);
            function.setIn(presenceStart, presenceEnd, true);
        }
        for (SchedulingInterval schedulingInterval : filteredAbsenceIntervals) {
            int absenceStart = IntervalUtils.getNullSafeStartTime(schedulingInterval, this.timeTransformer);
            int absenceEnd = this.timeTransformer.getTimestep(schedulingInterval.getEndDate());
            function.setIn(absenceStart, absenceEnd, false);
        }
        return function;
    }

    private int getNullSafeLatestEndTimeStep(List<? extends SchedulingInterval> presenceIntervals) {
        int latest = 0;
        for (SchedulingInterval schedulingInterval : presenceIntervals) {
            int timeStep = this.getEndTimeStep(schedulingInterval);
            latest = Math.max(latest, timeStep);
        }
        return latest;
    }

    private int getEndTimeStep(SchedulingInterval presenceInterval) {
        long endDate = presenceInterval.getEndDate();
        return this.timeTransformer.getTimestep(endDate);
    }
}

