/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues.sync;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.utils.estimate.EstimateConversionUtil;
import com.radiantminds.roadmap.common.utils.estimate.EstimateUtil;
import com.radiantminds.roadmap.jira.common.components.issues.IssueFieldChange;
import com.radiantminds.roadmap.jira.common.components.issues.IssueFieldChanges;
import com.radiantminds.roadmap.jira.common.components.issues.sync.BaseSyncHandler;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;
import com.radiantminds.roadmap.jira.common.components.issues.sync.tasks.DetailsSyncTask;
import com.radiantminds.roadmap.jira.common.components.issues.sync.tasks.StoryPointsSyncTask;
import com.radiantminds.roadmap.jira.common.components.issues.sync.tasks.TimeEstimateSyncTask;
import com.radiantminds.roadmap.jira.common.components.issues.sync.tasks.TitleSyncTask;
import com.radiantminds.roadmap.jira.common.components.utils.JiraSyncUtil;
import com.radiantminds.roadmap.jira.common.components.utils.TimeTracking;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JiraToPortfolioSyncHandler
extends BaseSyncHandler {
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioEstimatePersistence estimatePersistence;
    private final ApplicationProperties applicationProperties;
    private final WorkItemExtension workItemExtension;
    private final JiraSyncUtil jiraSyncUtil;
    private final IssueFieldChanges changes;

    public JiraToPortfolioSyncHandler(PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, ApplicationProperties applicationProperties, WorkItemExtension workItemExtension, JiraSyncUtil jiraSyncUtil, IssueFieldChanges changes) {
        this.workItemPersistence = workItemPersistence;
        this.estimatePersistence = estimatePersistence;
        this.applicationProperties = applicationProperties;
        this.workItemExtension = workItemExtension;
        this.jiraSyncUtil = jiraSyncUtil;
        this.changes = changes;
    }

    public Set<SyncTask> getSyncTasks(IWorkItem workItem, IPlanConfiguration planConfiguration, Optional<Integer> stageId) throws SQLException {
        if (!JiraToPortfolioSyncHandler.isSyncEnabledForWorkItem(planConfiguration, workItem)) {
            return Sets.newHashSet();
        }
        List<Object> stageLinks = Lists.newArrayList();
        if (WorkItems.Types.STORY.equals(workItem.getType())) {
            stageLinks = this.jiraSyncUtil.getStageLinks(workItem.getId());
        }
        HashSet tasks = Sets.newHashSet();
        if (stageLinks.isEmpty()) {
            Optional<IssueFieldChange> summaryChange;
            Optional<IssueFieldChange> descriptionChange;
            if (planConfiguration.getSyncDescription().booleanValue() && (descriptionChange = this.changes.forDescription()).isPresent()) {
                tasks.add(new DetailsSyncTask(((IssueFieldChange)descriptionChange.get()).getNewValue()));
            }
            if (planConfiguration.getSyncSummary().booleanValue() && (summaryChange = this.changes.forSummary()).isPresent()) {
                tasks.add(new TitleSyncTask(((IssueFieldChange)summaryChange.get()).getNewValue()));
            }
        }
        if (planConfiguration.getSyncEstimates().booleanValue()) {
            if (PlanningUnit.STORY_POINTS.unit().equals(planConfiguration.getPlanningUnit())) {
                Optional<IssueFieldChange> storyPointsChange = this.changes.forStoryPoints();
                if (storyPointsChange.isPresent()) {
                    String newValue = ((IssueFieldChange)storyPointsChange.get()).getNewValue();
                    Double storyPoints = newValue == null || "".equals(newValue.trim()) ? null : Double.valueOf(Double.parseDouble(newValue));
                    tasks.add(new StoryPointsSyncTask(this.estimatePersistence, this.workItemPersistence, this.workItemExtension, storyPoints, stageId, stageLinks));
                }
            } else {
                Optional<IssueFieldChange> originalEstimateChange;
                boolean timetrackingEnabled = TimeTracking.isEnabled(this.applicationProperties);
                if (timetrackingEnabled && (originalEstimateChange = this.changes.forOriginalEstimates()).isPresent()) {
                    String newOriginalEstimateString = ((IssueFieldChange)originalEstimateChange.get()).getNewValue();
                    double coefficient = EstimateConversionUtil.getCoefficient(planConfiguration);
                    double newOriginalEstimate = Double.parseDouble(newOriginalEstimateString);
                    Double convertedEstimate = newOriginalEstimate * coefficient;
                    HashMap estimateMap = Maps.newHashMap();
                    estimateMap.put(EstimateUtil.EstimateType.ORIGINAL, convertedEstimate);
                    tasks.add(new TimeEstimateSyncTask(this.estimatePersistence, this.workItemPersistence, this.workItemExtension, estimateMap, planConfiguration.getPlanningUnit(), planConfiguration.getHoursPerDay(), stageId, stageLinks));
                }
            }
        }
        return tasks;
    }
}

