/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.javasimon.utils.bean.BeanUtilsException;
import org.javasimon.utils.bean.ClassUtils;

class NestedResolver {
    private Object nestedTarget;
    private String targetProperty;

    NestedResolver(Object target, String property) {
        this.nestedTarget = target;
        this.targetProperty = property;
        this.resolveNested();
    }

    private void resolveNested() {
        int separatorPos;
        while ((separatorPos = this.targetProperty.indexOf(46)) > 0) {
            String property = this.targetProperty.substring(0, separatorPos);
            this.targetProperty = this.targetProperty.substring(separatorPos + 1);
            this.nestedTarget = this.resolveNestedTarget(this.nestedTarget, property);
            if (this.nestedTarget != null) continue;
            throw new BeanUtilsException(String.format("Nested bean %s is null", property));
        }
    }

    private Object resolveNestedTarget(Object nestedTarget, String propertyName) {
        try {
            Method getter = ClassUtils.getGetter(nestedTarget.getClass(), propertyName);
            if (getter != null) {
                return getter.invoke(nestedTarget, new Object[0]);
            }
            Field field = ClassUtils.getField(nestedTarget.getClass(), propertyName);
            if (field == null) {
                throw new BeanUtilsException(String.format("Failed to find property %s in %s", propertyName, nestedTarget));
            }
            field.setAccessible(true);
            return field.get(nestedTarget);
        }
        catch (IllegalAccessException e) {
            throw new BeanUtilsException(String.format("Failed to access property %s in object %s", propertyName, nestedTarget), e);
        }
        catch (InvocationTargetException e) {
            throw new BeanUtilsException(String.format("Failed to invoke getter %s in object %s", propertyName, nestedTarget), e);
        }
    }

    Object getNestedTarget() {
        return this.nestedTarget;
    }

    String getProperty() {
        return this.targetProperty;
    }
}

