/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

public class AvailabilityBasedSampling {
    private final Random random;

    public AvailabilityBasedSampling() {
        this(new Random(32423455L));
    }

    public AvailabilityBasedSampling(Random random) {
        this.random = random;
    }

    public Optional<AssignmentResource> sample(List<AssignmentResource> pool, PrimitivesMap<AssignmentResource> timeIndexAvailabilities) {
        if (pool.isEmpty()) {
            return Optional.absent();
        }
        float[] cumulativeAvailabilities = this.generateCumulativeNormalizedAvailabilities(pool, timeIndexAvailabilities);
        return Optional.of((Object)this.selectAvailabilitySampling(pool, cumulativeAvailabilities));
    }

    private AssignmentResource selectAvailabilitySampling(List<AssignmentResource> pool, float[] cumulativeAvailabilities) {
        float avaialabilityRandomValue = this.random.nextFloat();
        int index = Arrays.binarySearch(cumulativeAvailabilities, avaialabilityRandomValue);
        if (index < 0) {
            index = Math.abs(index + 1);
        }
        return pool.get(Math.min(pool.size() - 1, index));
    }

    private float[] generateCumulativeNormalizedAvailabilities(List<AssignmentResource> pool, PrimitivesMap<AssignmentResource> availabilities) {
        float[] cumulativeAvailabilities = new float[pool.size()];
        ListIterator<AssignmentResource> resources = pool.listIterator();
        for (int i = 0; i < cumulativeAvailabilities.length; ++i) {
            if (i == 0) {
                cumulativeAvailabilities[0] = this.getNormalized((AssignmentResource)resources.next(), availabilities);
                continue;
            }
            cumulativeAvailabilities[i] = cumulativeAvailabilities[i - 1] + this.getNormalized((AssignmentResource)resources.next(), availabilities);
        }
        return cumulativeAvailabilities;
    }

    private float getNormalized(AssignmentResource next, PrimitivesMap<AssignmentResource> availabilities) {
        float valueSum = availabilities.getValueSum();
        if (valueSum == 0.0f) {
            return 1.0f / (float)availabilities.size();
        }
        return availabilities.get(next) / valueSum;
    }
}

