/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl;

import com.atlassian.pocketknife.api.querydsl.ClosePromise;
import com.atlassian.pocketknife.api.querydsl.CloseableIterable;
import com.atlassian.pocketknife.api.querydsl.ConnectionProvider;
import com.atlassian.pocketknife.api.querydsl.DialectProvider;
import com.atlassian.pocketknife.api.querydsl.QueryFactory;
import com.atlassian.pocketknife.api.querydsl.SelectQuery;
import com.atlassian.pocketknife.api.querydsl.StreamyResult;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.dml.SQLDeleteClause;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.sql.dml.SQLMergeClause;
import com.mysema.query.sql.dml.SQLUpdateClause;
import java.sql.Connection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class QueryFactoryImpl
implements QueryFactory {
    private final ConnectionProvider connectionProvider;
    private final DialectProvider dialectProvider;

    @Autowired
    public QueryFactoryImpl(ConnectionProvider connectionProvider, DialectProvider dialectProvider) {
        this.connectionProvider = connectionProvider;
        this.dialectProvider = dialectProvider;
    }

    @Override
    public SelectQuery select(Connection connection) {
        return this.selectQueryImpl(connection, ClosePromise.NOOP());
    }

    @Override
    public SelectQuery select(Connection connection, ClosePromise closePromise) {
        return this.selectQueryImpl(connection, closePromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T fetch(Function<SQLQuery, T> function) {
        Connection connection = this.connectionProvider.borrowConnection();
        try {
            Object object = function.apply((Object)this.queryDSLQueryImpl(connection));
            return (T)object;
        }
        finally {
            this.connectionProvider.returnConnection(connection);
        }
    }

    @Override
    public StreamyResult select(Function<SelectQuery, StreamyResult> function) {
        Connection connection = this.connectionProvider.borrowConnection();
        ClosePromise closeEffect = this.returnConnection(connection);
        return this.streamyImpl(connection, closeEffect, function);
    }

    @Override
    public StreamyResult select(Connection connection, Function<SelectQuery, StreamyResult> function) {
        return this.streamyImpl(connection, ClosePromise.NOOP(), function);
    }

    @Override
    public StreamyResult select(Connection connection, ClosePromise closePromise, Function<SelectQuery, StreamyResult> function) {
        return this.streamyImpl(connection, closePromise, function);
    }

    private StreamyResult streamyImpl(Connection connection, ClosePromise closeEffect, Function<SelectQuery, StreamyResult> function) {
        try {
            SelectQuery select = this.selectQueryImpl(connection, closeEffect);
            return (StreamyResult)function.apply((Object)select);
        }
        catch (RuntimeException rte) {
            closeEffect.close();
            throw rte;
        }
    }

    private Configuration getConfiguration(Connection connection) {
        return this.dialectProvider.getDialectConfig(connection).getConfiguration();
    }

    private SQLQuery queryDSLQueryImpl(Connection connection) {
        Configuration configuration = this.getConfiguration(connection);
        return new SQLQuery(connection, configuration);
    }

    private SelectQuery selectQueryImpl(Connection connection, ClosePromise closePromise) {
        return new SelectQuery(this.queryDSLQueryImpl(connection), closePromise);
    }

    @Override
    public <T> List<T> halfStreamyMap(QueryFactory.HalfStreamyMapClosure<T> closure) {
        StreamyResult resultStream = this.select(closure.getQuery());
        try (CloseableIterable<T> iterable = resultStream.map(closure.getMapFunction());){
            ImmutableList immutableList = ImmutableList.copyOf(iterable);
            return immutableList;
        }
    }

    @Override
    public <T> T halfStreamyFold(T initial, QueryFactory.HalfStreamyFoldClosure<T> closure) {
        StreamyResult resultStream = this.select(closure.getQuery());
        return resultStream.foldLeft(initial, closure.getFoldFunction());
    }

    private ClosePromise returnConnection(final Connection connection) {
        return new ClosePromise(new Runnable(){

            @Override
            public void run() {
                QueryFactoryImpl.this.connectionProvider.returnConnection(connection);
            }
        });
    }

    @Override
    public SQLInsertClause insert(Connection connection, RelationalPath<?> table) {
        return new SQLInsertClause(connection, this.getConfiguration(connection), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T insert(RelationalPath<?> table, Function<SQLInsertClause, T> function) {
        Connection connection = this.connectionProvider.borrowAutoCommitConnection();
        try {
            Object object = function.apply((Object)this.insert(connection, table));
            return (T)object;
        }
        finally {
            this.connectionProvider.returnConnection(connection);
        }
    }

    @Override
    public SQLUpdateClause update(Connection connection, RelationalPath<?> table) {
        return new SQLUpdateClause(connection, this.getConfiguration(connection), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T update(RelationalPath<?> table, Function<SQLUpdateClause, T> function) {
        Connection connection = this.connectionProvider.borrowAutoCommitConnection();
        try {
            Object object = function.apply((Object)this.update(connection, table));
            return (T)object;
        }
        finally {
            this.connectionProvider.returnConnection(connection);
        }
    }

    @Override
    public SQLDeleteClause delete(Connection connection, RelationalPath<?> table) {
        return new SQLDeleteClause(connection, this.getConfiguration(connection), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T delete(RelationalPath<?> table, Function<SQLDeleteClause, T> function) {
        Connection connection = this.connectionProvider.borrowAutoCommitConnection();
        try {
            Object object = function.apply((Object)this.delete(connection, table));
            return (T)object;
        }
        finally {
            this.connectionProvider.returnConnection(connection);
        }
    }

    @Override
    public SQLMergeClause merge(Connection connection, RelationalPath<?> table) {
        return new SQLMergeClause(connection, this.getConfiguration(connection), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T merge(RelationalPath<?> table, Function<SQLMergeClause, T> function) {
        Connection connection = this.connectionProvider.borrowAutoCommitConnection();
        try {
            Object object = function.apply((Object)this.merge(connection, table));
            return (T)object;
        }
        finally {
            this.connectionProvider.returnConnection(connection);
        }
    }
}

