/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira;

import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.rm.common.bridges.api.Version;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.SimpleJiraVersionAccessor")
public class SimpleJiraVersionAccessor {
    private final BuildUtilsInfo buildUtilsInfo;
    private Version version;

    @Autowired
    public SimpleJiraVersionAccessor(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = buildUtilsInfo;
    }

    public Version getVersion() {
        if (this.version == null) {
            this.version = new Version(this.buildUtilsInfo.getVersion());
        }
        return this.version;
    }

    public boolean isInVersionRange(Version version) {
        Version jira = this.getVersion();
        return jira != null && jira.isInRange(version);
    }
}

