/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetResourcePoolScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingTerminationCondition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.GroupActivitySchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.IGroupActivityScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.IGroupActivitySchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.RobustGroupActivityScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.WorkSlotExceededWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;

public class GroupActivitySetScheduler
implements IActivitySetResourcePoolScheduler {
    private static final Log LOGGER = Log.with(GroupActivitySetScheduler.class);
    private final IGroupActivityScheduler groupActivityScheduler;

    GroupActivitySetScheduler(IGroupActivityScheduler groupActivityScheduler) {
        this.groupActivityScheduler = groupActivityScheduler;
    }

    public GroupActivitySetScheduler(int maxTestAssignmentsPerTeamStage, CancellationState cancellationState) {
        this(new RobustGroupActivityScheduler(maxTestAssignmentsPerTeamStage, cancellationState));
    }

    @Override
    public Optional<IActivitySetSchedule> tryScheduleActivitySetForResourcePool(IActivitySetSchedulingProblem problem, IMutableResourcePool mutableResourcePool, IActivitySetSchedulingTerminationCondition terminationCondition) throws InterruptedException {
        Preconditions.checkNotNull((Object)terminationCondition, (Object)"termination condition must no be null");
        LogUtil.debug(LOGGER, "schedule problem %s with resource pool: %s", problem, mutableResourcePool);
        IMutableResourceGroup group = mutableResourcePool.getMutableResourceGroup();
        boolean stageTransitionEnforced = problem.isStageTransitionEnforced();
        boolean needsScheduling = !stageTransitionEnforced;
        int nextActivityReleaseTime = problem.getLowerTimeBound();
        HashSet activitySchedules = Sets.newHashSet();
        HashSet warnings = Sets.newHashSet();
        for (IActivity activity : problem.getActivitySet().getActivities()) {
            LogUtil.debug(LOGGER, "schedule activity: %s", activity);
            Optional<IGroupActivitySchedulingProblem> groupActivitySchedulingProblem = GroupActivitySchedulingProblem.tryCreateActivitySchedulingProblem(problem, activity, nextActivityReleaseTime, mutableResourcePool);
            if (!groupActivitySchedulingProblem.isPresent()) {
                LogUtil.debug(LOGGER, "could not create scheduling problem");
                if (needsScheduling) {
                    group.unscheduleAssignables(activitySchedules);
                }
                return Optional.absent();
            }
            Optional<IActivitySchedule> activitySchedule = this.groupActivityScheduler.tryScheduleWithTimeBound((IGroupActivitySchedulingProblem)groupActivitySchedulingProblem.get(), terminationCondition.getUpperTimeBound());
            if (!activitySchedule.isPresent()) {
                LogUtil.debug(LOGGER, "could not create schedule");
                if (needsScheduling) {
                    group.unscheduleAssignables(activitySchedules);
                }
                return Optional.absent();
            }
            activitySchedules.add(activitySchedule.get());
            if (needsScheduling) {
                group.schedule(((IActivitySchedule)activitySchedule.get()).getWorkAssignments());
            }
            if (group.isWorkSlotStrict() && ((IActivitySchedule)activitySchedule.get()).getUsedWorkSlots().size() > 1) {
                LogUtil.debug(LOGGER, "add work slot exceeding warning");
                warnings.add(new WorkSlotExceededWarning(problem.getActivitySet(), activity));
            }
            nextActivityReleaseTime = this.updateActivityReleaseTime((IActivitySchedule)activitySchedule.get(), group, stageTransitionEnforced);
        }
        ActivitySetSchedule schedule = ActivitySetSchedule.createSchedule(problem.getActivitySet(), group.getDefinition(), activitySchedules, warnings, problem.getCausalReleaseTime());
        if (needsScheduling) {
            group.unschedule(schedule.getWorkAssignments());
        }
        LogUtil.debug(LOGGER, "created schedule: %s", schedule);
        return Optional.of((Object)schedule);
    }

    private int updateActivityReleaseTime(IActivitySchedule activitySchedule, IMutableResourceGroup group, boolean stageTransitionEnforced) {
        if (!stageTransitionEnforced) {
            return activitySchedule.getStart();
        }
        return group.getNextValidWorkSlotForReleaseTime(activitySchedule.getEnd() + 1).getStart();
    }
}

