/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.FinishableTest;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class AbstractMutableResourcePool
implements IMutableResourcePool {
    protected final IMutableResourceGroup resourceGroup;
    private final IWorkSlot firstMonotoneWorkSlot;
    private final Set<IResourceType> limitedAvailabilityTypes;
    private final Set<IMutableResource> limitedAvailabilityResources;
    private final Set<IMutableResource> mutableResources;
    private final String sortKey;

    AbstractMutableResourcePool(IMutableResourceGroup resourceGroup, Set<IMutableResource> mutableResources, String sortKey) {
        this.resourceGroup = resourceGroup;
        this.firstMonotoneWorkSlot = AbstractMutableResourcePool.calculateFirstMonotoneSlot(mutableResources, resourceGroup);
        this.limitedAvailabilityResources = AbstractMutableResourcePool.calculateLimitedResources(mutableResources);
        Set<IResourceType> allTypesInGroup = RmSchedulingUtils.getMergedResourceTypes(mutableResources);
        Sets.SetView unlimitedResource = Sets.difference(mutableResources, this.limitedAvailabilityResources);
        Set<IResourceType> unlimitedResourceTypes = RmSchedulingUtils.getMergedResourceTypes(unlimitedResource);
        this.limitedAvailabilityTypes = Sets.difference(allTypesInGroup, unlimitedResourceTypes);
        this.sortKey = sortKey;
        this.mutableResources = mutableResources;
    }

    private static Set<IMutableResource> calculateLimitedResources(Set<IMutableResource> mutableResources) {
        HashSet limitedAvailable = Sets.newHashSet();
        for (IMutableResource resource : mutableResources) {
            if (resource.isUnlimitedAvailable()) continue;
            limitedAvailable.add(resource);
        }
        return limitedAvailable;
    }

    private static IWorkSlot calculateFirstMonotoneSlot(Set<IMutableResource> mutableResources, IMutableResourceGroup resourceGroup) {
        int latestStep = 0;
        for (IMutableResource resource : mutableResources) {
            int firstRegularTimeStep = resource.getFirstRegularTimeStep();
            latestStep = Math.max(latestStep, firstRegularTimeStep);
        }
        return resourceGroup.getNextWorkSlotWithFullPresence(latestStep);
    }

    @Override
    public boolean isFinishableWithoutTimeLimit(PositivePrimitivesMap<IResourceType> requiredWork, PositivePrimitivesMap<IMutableResource> availableWork) {
        PositivePrimitivesMap<IResourceType> limitedRequiredWork = RmCollectionUtils.filterKeys(requiredWork, Predicates.in(this.limitedAvailabilityTypes));
        PositivePrimitivesMap<IMutableResource> limitedResourceAvailabilities = RmCollectionUtils.filterKeys(availableWork, Predicates.in(this.limitedAvailabilityResources));
        return FinishableTest.isFinishable(limitedRequiredWork, limitedResourceAvailabilities);
    }

    @Override
    public String getId() {
        return this.resourceGroup.getId();
    }

    @Override
    public IWorkSlot getNextValidWorkSlotForReleaseTime(int releaseTime) {
        return this.resourceGroup.getNextValidWorkSlotForReleaseTime(releaseTime);
    }

    @Override
    public IWorkSlot getNextWorkSlot(IWorkSlot workSlot) {
        return this.resourceGroup.getNextWorkSlot(workSlot);
    }

    @Override
    public List<IWorkSlot> getWorkSlotsBetween(int startTime, int endTime) {
        return this.resourceGroup.getWorkSlotsBetween(startTime, endTime);
    }

    @Override
    public boolean isWorkSlotStrict() {
        return this.resourceGroup.isWorkSlotStrict();
    }

    @Override
    public IMutableResourceGroup getMutableResourceGroup() {
        return this.resourceGroup;
    }

    @Override
    public IWorkSlot getFirstConstantWorkSlotWithDefaultPresence() {
        return this.firstMonotoneWorkSlot;
    }

    @Override
    public IWorkSlot getNextWorkSlotWithFullPresence(int timeStep) {
        return this.resourceGroup.getNextWorkSlotWithFullPresence(timeStep);
    }

    @Override
    public IWorkSlot getWorkSlotWithIndex(int slotIndex) {
        return this.resourceGroup.getWorkSlotWithIndex(slotIndex);
    }

    @Override
    public int getStartTimeStep(int slotIndex) {
        return this.resourceGroup.getStartTimeStep(slotIndex);
    }

    @Override
    public int getEndTimeStep(int slotIndex) {
        return this.resourceGroup.getEndTimeStep(slotIndex);
    }

    @Override
    public int getDefaultSlotLength() {
        return this.resourceGroup.getDefaultSlotLength();
    }

    @Override
    public Set<IMutableResource> getMutableResources() {
        return this.mutableResources;
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return RmSchedulingUtils.getMergedResourceTypes(this.mutableResources);
    }

    @Override
    public MutablePositivePrimitivesMap<IMutableResource> getSchedulableWorkInTimeSlot(int slotIndex) {
        MutablePositivePrimitivesMap<IMutableResource> freeWork = RmCollectionUtils.newMutablePositiveMap(this.mutableResources.size());
        for (IMutableResource resource : this.mutableResources) {
            freeWork.put(resource, resource.getUnassignedWorkInWorkSlot(slotIndex));
        }
        return freeWork;
    }

    @Override
    public IWorkSlot getEarliestConstantSlotWithoutAssignment(int earliestSlotIndex) {
        IWorkSlot firstConstantWorkSlot = this.getFirstConstantWorkSlotWithDefaultPresence();
        IWorkSlot earliestSlot = this.getWorkSlotWithIndex(earliestSlotIndex);
        if (earliestSlot.getStart() < firstConstantWorkSlot.getStart()) {
            earliestSlot = firstConstantWorkSlot;
        }
        while (!this.noAssignments(this.mutableResources, earliestSlot)) {
            earliestSlot = this.resourceGroup.getNextWorkSlot(earliestSlot);
        }
        return earliestSlot;
    }

    private boolean noAssignments(Set<IMutableResource> mutableResources, IWorkSlot workSlot) {
        for (IMutableResource resource : mutableResources) {
            float assignedWorkInWorkSlot = resource.getAssignedWorkInWorkSlot(workSlot.getIndex());
            if (!(assignedWorkInWorkSlot > 0.01f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    @Override
    public Optional<IWorkSlot> tryGetWorkSlotWithId(String slotId) {
        return this.resourceGroup.tryGetWorkSlotWithId(slotId);
    }

    @Override
    public IWorkSlot getSlotOrNextForTimeStep(int timeStep) {
        return this.resourceGroup.getSlotOrNextForTimeStep(timeStep);
    }

    @Override
    public boolean isRestrictedWorkSlot(int slotIndex) {
        return this.resourceGroup.isRestrictedWorkSlot(slotIndex);
    }

    @Override
    public IWorkSlot getFirstRegularSlot() {
        return this.resourceGroup.getFirstRegularSlot();
    }
}

