/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.IFixedSlotsAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositiveTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FixedSlotsAssignmentProblem
implements IFixedSlotsAssignmentProblem {
    private final Map<IWorkSlot, Set<FixedSlotItemAssignmentProblem>> slotAssignmentProblems;
    private final IRoadmapProblem roadmapProblem;

    FixedSlotsAssignmentProblem(Map<IWorkSlot, Set<FixedSlotItemAssignmentProblem>> slotAssignmentProblems, IRoadmapProblem roadmapProblem) {
        this.slotAssignmentProblems = slotAssignmentProblems;
        this.roadmapProblem = roadmapProblem;
    }

    public static Optional<FixedSlotsAssignmentProblem> tryCreate(IRoadmapProblem problem) {
        Map<IWorkSlot, Set<FixedSlotItemAssignmentProblem>> slotAssignmentProblems = FixedSlotsAssignmentProblem.getSlotProblems(problem);
        if (slotAssignmentProblems.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new FixedSlotsAssignmentProblem(slotAssignmentProblems, problem));
    }

    private static Map<IWorkSlot, Set<FixedSlotItemAssignmentProblem>> getSlotProblems(IRoadmapProblem problem) {
        HashMap slotAssignmentProblems = Maps.newHashMap();
        for (IProcessingItem item : problem.getBacklog().getProcessingItems()) {
            FixedSlotItemAssignmentProblem itemProblem = (FixedSlotItemAssignmentProblem)FixedSlotItemAssignmentProblem.tryCreateForItem(item).orNull();
            if (itemProblem == null) continue;
            RmUtils.addToKeyedSets(slotAssignmentProblems, itemProblem.getWorkSlot(), itemProblem);
        }
        return slotAssignmentProblems;
    }

    @Override
    public Set<IWorkSlot> getWorkSlotsWithAssignedItems() {
        return this.slotAssignmentProblems.keySet();
    }

    @Override
    public Set<FixedSlotItemAssignmentProblem> getAssignmentProblemsForSlot(IWorkSlot workSlot) {
        return this.slotAssignmentProblems.get(workSlot);
    }

    @Override
    public int getActivityResourceLimit() {
        return this.roadmapProblem.getProcessingDefinition().getMaxResourcesPerStage();
    }

    @Override
    public PositivePrimitivesMap<IWorkResource> getResourceAvailabilities(IWorkSlot workSlot) {
        MutablePositiveTroveMap<IWorkResource> resources = MutablePositiveTroveMap.create();
        for (FixedSlotItemAssignmentProblem slotAssignmentProblem : this.slotAssignmentProblems.get(workSlot)) {
            for (Map.Entry<IWorkResource, Float> entry : slotAssignmentProblem.getPositiveResourceAvailabilities().entrySet()) {
                resources.put(entry.getKey(), entry.getValue().floatValue());
            }
        }
        return resources;
    }

    @Override
    public List<IResourceType> getSortedResourceTypes(IWorkSlot workSlot) {
        HashSet allTypes = Sets.newHashSet();
        for (FixedSlotItemAssignmentProblem problem : this.slotAssignmentProblems.get(workSlot)) {
            allTypes.addAll(problem.getDemands().keySet());
        }
        return RmSortableUtils.sort(allTypes);
    }

    @Override
    public IResourceGroup getResourceGroup(IWorkSlot workSlot) {
        return (IResourceGroup)RmIdentifiableUtils.tryFindElementWithId(workSlot.getGroupId(), this.roadmapProblem.getResourceGroups()).get();
    }

    @Override
    public BiMap<String, IProcessingStage> getStages() {
        HashBiMap idMap = HashBiMap.create();
        for (IProcessingStage stage : this.roadmapProblem.getProcessingDefinition().getProcessingStages()) {
            idMap.put((Object)stage.getId(), (Object)stage);
        }
        return idMap;
    }
}

