/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentSolverApacheImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedActivityAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedActivityAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedActivityAssignmentSolverApacheImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ResourceSkillVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.ActivityResourceSkillVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.DefaultOverbookedPeriodAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.OverbookedPeriodAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.PeriodAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.PeriodAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.Sampling;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.SetCoverSampling;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IterativePeriodAssignmentSolver
implements PeriodAssignmentSolver {
    private static final Log LOGGER = Log.with(IterativePeriodAssignmentSolver.class);
    private final ActivityAssignmentSolver activityAssignmentSolver;
    private final OverbookedActivityAssignmentSolver overbookedActivityAssignmentSolver;
    private final Sampling sampling;

    public IterativePeriodAssignmentSolver() {
        this(new ActivityAssignmentSolverApacheImpl(), new OverbookedActivityAssignmentSolverApacheImpl(), new SetCoverSampling());
    }

    IterativePeriodAssignmentSolver(ActivityAssignmentSolver activityAssignmentSolver, OverbookedActivityAssignmentSolver overbookedActivityAssignmentSolver, Sampling sampling) {
        this.activityAssignmentSolver = activityAssignmentSolver;
        this.overbookedActivityAssignmentSolver = overbookedActivityAssignmentSolver;
        this.sampling = sampling;
    }

    @Override
    public OverbookedPeriodAssignmentSolution solve(PeriodAssignmentProblem problem) {
        LOGGER.debug("start solving period assignment problem: %s", problem);
        long startMs = System.currentTimeMillis();
        float[] remainingWork = problem.getRestrictedResourceAvailabilitiesCopy(problem.getResources());
        HashMap assignments = Maps.newHashMap();
        for (int activity = 0; activity < problem.getActivities(); ++activity) {
            if (problem.isEmptyActivity(activity)) {
                LOGGER.debug("encountered activity with no work to be done", new Object[0]);
                continue;
            }
            int[][] resourcesBatch = this.sampling.selectResourcesBatch(activity, remainingWork, problem);
            if (resourcesBatch.length == 0) continue;
            Optional<Map<ResourceSkillVariable, Float>> subProblemSolution = this.trySolveWithoutOverbooking(problem, activity, resourcesBatch, remainingWork);
            if (subProblemSolution.isPresent()) {
                for (Map.Entry entry : ((Map)subProblemSolution.get()).entrySet()) {
                    remainingWork[((ResourceSkillVariable)entry.getKey()).getResource()] = Math.max(0.0f, remainingWork[((ResourceSkillVariable)entry.getKey()).getResource()] - ((Float)entry.getValue()).floatValue());
                    RmUtils.addFloatsKeywise(assignments, IterativePeriodAssignmentSolver.createVariable(activity, (ResourceSkillVariable)entry.getKey()), ((Float)entry.getValue()).floatValue());
                }
                continue;
            }
            Optional<Map<ResourceSkillVariable, Float>> overbookSolution = this.trySolveWithOverbooking(problem, activity, resourcesBatch, remainingWork);
            if (overbookSolution.isPresent()) {
                for (Map.Entry entry : ((Map)overbookSolution.get()).entrySet()) {
                    remainingWork[((ResourceSkillVariable)entry.getKey()).getResource()] = Math.max(0.0f, remainingWork[((ResourceSkillVariable)entry.getKey()).getResource()] - ((Float)entry.getValue()).floatValue());
                    RmUtils.addFloatsKeywise(assignments, IterativePeriodAssignmentSolver.createVariable(activity, (ResourceSkillVariable)entry.getKey()), ((Float)entry.getValue()).floatValue());
                }
                continue;
            }
            LOGGER.warn("no solution found for activity: %d", activity);
        }
        OverbookedPeriodAssignmentSolution solution = DefaultOverbookedPeriodAssignmentSolution.create(assignments, problem);
        float solverTimeMs = System.currentTimeMillis() - startMs;
        LOGGER.debug("executed resolution in %d ms and found solution: %s", Float.valueOf(solverTimeMs), solution);
        return solution;
    }

    private Optional<Map<ResourceSkillVariable, Float>> trySolveWithOverbooking(PeriodAssignmentProblem problem, int activity, int[][] resourcesBatch, float[] remainingWork) {
        LOGGER.debug("try solve activity %d with overbooking resources", activity);
        Optional<OverbookedActivityAssignmentSolution> bestSolution = Optional.absent();
        int[] bestResources = null;
        for (int[] resources : resourcesBatch) {
            ActivityAssignmentProblem feasibilityProblem = problem.getSubProblem(activity, Ints.asList((int[])resources), this.getAvailabilities(remainingWork, resources));
            Optional<OverbookedActivityAssignmentSolution> solution = this.overbookedActivityAssignmentSolver.solve(feasibilityProblem);
            if (!IterativePeriodAssignmentSolver.isBetter(solution, bestSolution)) continue;
            bestSolution = solution;
            bestResources = resources;
        }
        if (bestSolution.isPresent()) {
            LOGGER.debug("found solution: %s", bestSolution.get());
            return Optional.of(IterativePeriodAssignmentSolver.transform((ActivityAssignment)bestSolution.get(), bestResources));
        }
        LOGGER.debug("no solution found", new Object[0]);
        return Optional.absent();
    }

    private Optional<Map<ResourceSkillVariable, Float>> trySolveWithoutOverbooking(PeriodAssignmentProblem problem, int activity, int[][] resourcesBatch, float[] remainingWork) {
        LOGGER.debug("try solve activity %d without overbooking resources", activity);
        for (int[] resources : resourcesBatch) {
            ActivityAssignmentProblem feasibilityProblem = problem.getSubProblem(activity, Ints.asList((int[])resources), this.getAvailabilities(remainingWork, resources));
            Optional<ActivityAssignmentSolution> solution = this.activityAssignmentSolver.solveWithoutOverbooking(feasibilityProblem);
            if (!solution.isPresent()) continue;
            LOGGER.debug("found solution: %s", solution.get());
            return Optional.of(IterativePeriodAssignmentSolver.transform((ActivityAssignment)solution.get(), resources));
        }
        LOGGER.debug("no solution found", new Object[0]);
        return Optional.absent();
    }

    private List<Float> getAvailabilities(float[] remainingWork, int[] resources) {
        ArrayList work = Lists.newArrayList();
        for (int i = 0; i < resources.length; ++i) {
            work.add(Float.valueOf(remainingWork[resources[i]]));
        }
        return work;
    }

    private static Map<ResourceSkillVariable, Float> transform(ActivityAssignment assignment, int[] resources) {
        HashMap assignments = Maps.newHashMap();
        for (int r = 0; r < assignment.getResources(); ++r) {
            for (int s = 0; s < assignment.getSkills(); ++s) {
                if (!(assignment.getLoad(r, s) > 0.01f)) continue;
                assignments.put(new ResourceSkillVariable(resources[r], s), Float.valueOf(assignment.getLoad(r, s)));
            }
        }
        return assignments;
    }

    private static boolean isBetter(Optional<OverbookedActivityAssignmentSolution> solution1, Optional<OverbookedActivityAssignmentSolution> solution2) {
        if (!solution1.isPresent()) {
            return false;
        }
        if (!solution2.isPresent()) {
            return true;
        }
        return ((OverbookedActivityAssignmentSolution)solution1.get()).getOverbookedSum() < ((OverbookedActivityAssignmentSolution)solution2.get()).getOverbookedSum();
    }

    private static ActivityResourceSkillVariable createVariable(int activity, ResourceSkillVariable variable) {
        return new ActivityResourceSkillVariable(activity, variable.getResource(), variable.getSkill());
    }
}

