/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.BaseProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DecisionVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.MaximizeWorkProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.uncommons.maths.combinatorics.CombinationGenerator;

class DistributeOverbookProblem
extends BaseProblem {
    private final MaximizeWorkProblem maxWorkProblem;
    private final Set<DecisionVariable> overbookedVariables;
    private final LinkedHashMap<Pair<IWorkResource, IWorkResource>, Pair<Integer, Integer>> pairs;
    private final float validWork;

    DistributeOverbookProblem(Set<DecisionVariable> overbookedVariables, LinkedHashMap<Pair<IWorkResource, IWorkResource>, Pair<Integer, Integer>> pairs, float validWork, MaximizeWorkProblem maximizeWorkProblem) {
        super((Set<DecisionVariable>)Sets.union(maximizeWorkProblem.getWorkDecisionVariables(), overbookedVariables), maximizeWorkProblem.getItems(), maximizeWorkProblem.getWorkSlot(), maximizeWorkProblem.getResources(), maximizeWorkProblem.getDemands());
        this.maxWorkProblem = maximizeWorkProblem;
        this.pairs = pairs;
        this.validWork = validWork;
        this.overbookedVariables = overbookedVariables;
    }

    @Override
    Set<DecisionVariable> getWorkDecisionVariables() {
        return Sets.union(this.maxWorkProblem.getWorkDecisionVariables(), this.overbookedVariables);
    }

    Set<Integer> getDistributionIndices() {
        HashSet indices = Sets.newHashSet();
        for (Pair<Integer, Integer> pair : this.pairs.values()) {
            indices.add(pair.getLeft());
            indices.add(pair.getRight());
        }
        return indices;
    }

    @Override
    Set<DecisionVariable> getLimitedVariablesForResource(String resourceId) {
        return this.maxWorkProblem.getLimitedVariablesForResource(resourceId);
    }

    @Override
    int getVariableCount() {
        return this.maxWorkProblem.getVariableCount() * 2 + 2 * this.pairs.size();
    }

    Iterable<Pair<IWorkResource, IWorkResource>> getResourcePairs() {
        return Lists.newArrayList(this.pairs.keySet());
    }

    int getPairCount() {
        return this.pairs.size();
    }

    Pair<Integer, Integer> getDistributionIndices(Pair<IWorkResource, IWorkResource> resourcePair) {
        return this.pairs.get(resourcePair);
    }

    Set<DecisionVariable> getUnlimitedDecisionVariables(final String resourceId) {
        return Sets.filter(this.overbookedVariables, (Predicate)new Predicate<DecisionVariable>(){

            public boolean apply(DecisionVariable decisionVariable) {
                return resourceId.equals(decisionVariable.getResource().getId());
            }
        });
    }

    Set<DecisionVariable> getLimitedVariables() {
        return this.maxWorkProblem.getWorkDecisionVariables();
    }

    double getValidWork() {
        return this.validWork;
    }

    static DistributeOverbookProblem create(MaximizeWorkProblem maxWorkProblem, float validWorkSum) {
        return new DistributeOverbookProblem(DistributeOverbookProblem.createOverbookVariables(maxWorkProblem.getWorkDecisionVariables()), DistributeOverbookProblem.createResourcePairMap(maxWorkProblem), validWorkSum, maxWorkProblem);
    }

    private static LinkedHashMap<Pair<IWorkResource, IWorkResource>, Pair<Integer, Integer>> createResourcePairMap(MaximizeWorkProblem problem) {
        if (problem.getResources().size() < 2) {
            return Maps.newLinkedHashMap();
        }
        LinkedHashMap resourcePairMap = Maps.newLinkedHashMap();
        CombinationGenerator<IWorkResource> generator = new CombinationGenerator<IWorkResource>(problem.getResources(), 2);
        while (generator.hasMore()) {
            List<IWorkResource> nextPair = generator.nextCombinationAsList();
            int nextIndex = problem.getVariableCount() * 2 + resourcePairMap.size();
            resourcePairMap.put(new ImmutablePair<IWorkResource, IWorkResource>(nextPair.get(0), nextPair.get(1)), new ImmutablePair<Integer, Integer>(nextIndex, nextIndex + 1));
        }
        return resourcePairMap;
    }

    private static Set<DecisionVariable> createOverbookVariables(Set<DecisionVariable> limitedVariables) {
        HashSet unlimitedVariables = Sets.newHashSet();
        for (DecisionVariable limitedVariable : limitedVariables) {
            unlimitedVariables.add(new DecisionVariable(limitedVariable.getResource(), limitedVariable.getResourceType(), limitedVariable.getProcessingItem(), limitedVariable.getAssignmentId(), limitedVariables.size() + limitedVariable.getIndex(), limitedVariable.getResourceGroup(), limitedVariable.getProcessingStage()));
        }
        return unlimitedVariables;
    }
}

