/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.CoveringEpisodeSelector;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.MinEpisodeStartShiftSelector;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.EpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;

class EpisodeScheduleSelector {
    private final CoveringEpisodeSelector coveringEpisodeSelector;
    private final MinEpisodeStartShiftSelector minEpisodeStartShiftSelector;

    EpisodeScheduleSelector(CoveringEpisodeSelector coveringEpisodeSelector, MinEpisodeStartShiftSelector minEpisodeStartShiftSelector) {
        this.coveringEpisodeSelector = coveringEpisodeSelector;
        this.minEpisodeStartShiftSelector = minEpisodeStartShiftSelector;
    }

    public EpisodeScheduleSelector() {
        this(new CoveringEpisodeSelector(), new MinEpisodeStartShiftSelector());
    }

    IEpisodeSchedule getScheduleToAdd(IIntegerInterval solutionInterval, LinkedHashMap<IEpisode, Optional<Integer>> possibleEpisodes, BiMap<String, IEpisodeSchedule> episodeSchedules) {
        Optional<IEpisodeSchedule> coveringSchedule = this.coveringEpisodeSelector.tryGetCoveringSchedule(solutionInterval, possibleEpisodes, episodeSchedules);
        if (coveringSchedule.isPresent()) {
            return (IEpisodeSchedule)coveringSchedule.get();
        }
        Optional<IEpisodeSchedule> minShiftSchedule = this.minEpisodeStartShiftSelector.tryGetMinShiftSchedule(solutionInterval, possibleEpisodes, episodeSchedules);
        if (minShiftSchedule.isPresent()) {
            return (IEpisodeSchedule)minShiftSchedule.get();
        }
        return this.getLatestPossibleEpisode(Lists.newArrayList(possibleEpisodes.keySet()), episodeSchedules, solutionInterval);
    }

    private IEpisodeSchedule getLatestPossibleEpisode(List<IEpisode> possibleEpisodes, BiMap<String, IEpisodeSchedule> episodeSchedules, IIntegerInterval solution) {
        IEpisodeSchedule laterSchedule = (IEpisodeSchedule)episodeSchedules.get((Object)possibleEpisodes.get(possibleEpisodes.size() - 1).getId());
        if (laterSchedule == null) {
            return EpisodeSchedule.createEmpty(possibleEpisodes.get(possibleEpisodes.size() - 1), solution.getStart());
        }
        return laterSchedule;
    }
}

