/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IMutableAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FreedWorkCalculator {
    private static final Log LOGGER = Log.with(FreedWorkCalculator.class);
    private final LinkedHashMap<IProcessingStage, Map.Entry<IProcessingStage, Float>> stageToNextStageFactors;

    public FreedWorkCalculator(LinkedHashMap<IProcessingStage, Map.Entry<IProcessingStage, Float>> stageToNextStageFactors) {
        this.stageToNextStageFactors = stageToNextStageFactors;
    }

    public Optional<Map.Entry<IProcessingStage, Float>> calculateFreedForStage(IProcessingStage doneStage, float doneAmount, IMutableAggregatedWorkPackage workTodo) {
        Map.Entry<IProcessingStage, Float> nextStageEntry = this.stageToNextStageFactors.get(doneStage);
        if (nextStageEntry == null) {
            LogUtil.debug(LOGGER, "no succeeding stage");
            return Optional.absent();
        }
        IProcessingStage freedStage = nextStageEntry.getKey();
        Optional<MutableStageWorkPackage> todoForFreedStage = workTodo.getWorkPackageForStage(freedStage);
        if (!todoForFreedStage.isPresent()) {
            LOGGER.warn("freed stage %s is already worked off", freedStage);
            return Optional.absent();
        }
        float openAmountFreedStage = ((MutableStageWorkPackage)todoForFreedStage.get()).getAmount();
        Optional<MutableStageWorkPackage> todoForDoneStage = workTodo.getWorkPackageForStage(doneStage);
        if (!todoForDoneStage.isPresent()) {
            LogUtil.debug(LOGGER, "previous stage worked off - free all");
            AbstractMap.SimpleEntry<IProcessingStage, Float> entry = new AbstractMap.SimpleEntry<IProcessingStage, Float>(freedStage, Float.valueOf(openAmountFreedStage));
            return Optional.of(entry);
        }
        float openAmountDoneStage = ((MutableStageWorkPackage)todoForDoneStage.get()).getAmount();
        if (openAmountDoneStage < 0.01f) {
            LogUtil.debug(LOGGER, "previous stage worked off by slack value - free all");
            AbstractMap.SimpleEntry<IProcessingStage, Float> entry = new AbstractMap.SimpleEntry<IProcessingStage, Float>(freedStage, Float.valueOf(openAmountFreedStage));
            return Optional.of(entry);
        }
        float factor = nextStageEntry.getValue().floatValue();
        float freed = factor * doneAmount;
        LogUtil.debug(LOGGER, "calcluated freed amount: %s", Float.valueOf(freed));
        AbstractMap.SimpleEntry<IProcessingStage, Float> entry = new AbstractMap.SimpleEntry<IProcessingStage, Float>(freedStage, Float.valueOf(freed));
        return Optional.of(entry);
    }

    public static FreedWorkCalculator createInstance(IAggregatedWorkPackage workPackage) {
        LinkedHashMap<IProcessingStage, Map.Entry<IProcessingStage, Float>> factors = FreedWorkCalculator.calculatetTransitionFactors(workPackage);
        return new FreedWorkCalculator(factors);
    }

    private static LinkedHashMap<IProcessingStage, Map.Entry<IProcessingStage, Float>> calculatetTransitionFactors(IAggregatedWorkPackage workPackage) {
        LinkedHashMap empty = Maps.newLinkedHashMap();
        List<IProcessingStage> stages = workPackage.getSpecifiedStages();
        int stageCount = stages.size();
        for (int i = 0; i < stageCount - 1; ++i) {
            IProcessingStage stage = stages.get(i);
            IProcessingStage succStage = stages.get(i + 1);
            float stageDemand = ((IProcessingStageWorkPackage)workPackage.getWorkPackageForStage(stage).get()).getAmount();
            float succStageDemand = ((IProcessingStageWorkPackage)workPackage.getWorkPackageForStage(succStage).get()).getAmount();
            float factor = succStageDemand / stageDemand;
            Map.Entry<IProcessingStage, Float> entry = RmUtils.createEntry(succStage, Float.valueOf(factor));
            empty.put(stage, entry);
        }
        return empty;
    }
}

