/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import java.util.Set;

class MutableStageWorkPackageMapImpl
implements MutableStageWorkPackage {
    private static final Log LOGGER = Log.with(MutableStageWorkPackageMapImpl.class);
    private final IProcessingStage processingStage;
    private final MutablePositivePrimitivesMap<IResourceType> demandMap;

    public MutableStageWorkPackageMapImpl(IProcessingStage processingStage, MutablePositivePrimitivesMap<IResourceType> workPackage) {
        this.processingStage = processingStage;
        this.demandMap = workPackage;
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.demandMap.keySet();
    }

    @Override
    public IProcessingStage getProcessingStage() {
        return this.processingStage;
    }

    @Override
    public float getAmount() {
        return this.demandMap.getValueSum();
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getPositiveTypeAmounts() {
        return this.demandMap;
    }

    @Override
    public void decrease(PositivePrimitivesMap<IResourceType> minuend) {
        this.demandMap.subtract(minuend);
    }

    @Override
    public void increase(PositivePrimitivesMap<IResourceType> summand) {
        this.demandMap.add(summand);
    }

    @Override
    public boolean isEmpty() {
        return this.demandMap.isEmpty();
    }

    public static MutableStageWorkPackage createInstance(IProcessingStageWorkPackage workPackage) {
        MutablePositivePrimitivesMap<IResourceType> demand = RmCollectionUtils.newMutablePositiveMap(workPackage.getPositiveTypeAmounts());
        return new MutableStageWorkPackageMapImpl(workPackage.getProcessingStage(), demand);
    }

    public static MutableStageWorkPackage createInstance(Set<IProcessingStageWorkPackage> value) {
        MutablePositivePrimitivesMap<IResourceType> demand = RmCollectionUtils.newMutablePositiveMap();
        for (IProcessingStageWorkPackage workPackage : value) {
            demand.add(workPackage.getPositiveTypeAmounts());
        }
        return new MutableStageWorkPackageMapImpl(value.iterator().next().getProcessingStage(), demand);
    }
}

