/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.apache;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.apache.ApacheUnstructObjectiveCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.apache.IApacheUnstructuredObjectiveCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.BalancedStageLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.IUnstructuredStageLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.ApacheUtils;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.SortedPositivePrimitiveMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

class ApacheUnstructStageOptDataCreator {
    private static final Log LOGGER = Log.with(ApacheUnstructStageOptDataCreator.class);
    private final IApacheUnstructuredObjectiveCreator objectiveCreator;

    ApacheUnstructStageOptDataCreator(IApacheUnstructuredObjectiveCreator objectiveCreator) {
        this.objectiveCreator = objectiveCreator;
    }

    ApacheUnstructStageOptDataCreator() {
        this(new ApacheUnstructObjectiveCreator());
    }

    OptimizationData[] createOptimizationData(IUnstructuredStageLpProblem lpProblem) {
        LogUtil.debug(LOGGER, "create optimization data for problem: %s", lpProblem);
        BalancedStageLpProblem balancedProblem = BalancedStageLpProblem.createInstance(lpProblem);
        return this.createOptimizationData(balancedProblem);
    }

    OptimizationData[] createOptimizationData(BalancedStageLpProblem balancedProblem) {
        ArrayList optData = Lists.newArrayList();
        optData.add(GoalType.MAXIMIZE);
        LinearObjectiveFunction objectiveFunction = this.objectiveCreator.createObjectiveFunction(balancedProblem);
        optData.add(objectiveFunction);
        LinearConstraintSet constraints = this.createLinearConstraints(balancedProblem);
        optData.add(constraints);
        LogUtil.debugCollection(LOGGER, "created optimization data: %s", optData);
        return optData.toArray(new OptimizationData[optData.size()]);
    }

    private LinearConstraint createMinWorkLoadConstraint(BalancedStageLpProblem problem) {
        double[] coefficients = new double[problem.getVariableCount()];
        for (int i = 0; i < problem.getAssignmentVariableCount(); ++i) {
            coefficients[i] = 1.0;
        }
        double doableWorkLoad = this.calculateDoableWorkLoad(problem);
        double actualMinWorkLoad = Math.min((double)problem.getMinWorkLoad(), doableWorkLoad);
        LinearConstraint constraint = new LinearConstraint(coefficients, Relationship.GEQ, actualMinWorkLoad);
        return constraint;
    }

    private double calculateDoableWorkLoad(BalancedStageLpProblem problem) {
        Set<IResourceType> resourceTypes = problem.getResourceTypes();
        double sum = 0.0;
        for (IResourceType type : resourceTypes) {
            sum += (double)problem.getResourceTypeLimits().get(type);
        }
        return sum;
    }

    private List<LinearConstraint> createBalancingConstraints(BalancedStageLpProblem problem) {
        ArrayList constraints = Lists.newArrayList();
        int varCount = problem.getVariableCount();
        LinkedHashMap<List<IResourceType>, int[]> balanceIndicesMap = this.getOrderedMap(problem.getBalanceVarMap());
        for (Map.Entry<List<IResourceType>, int[]> entry : balanceIndicesMap.entrySet()) {
            List<IResourceType> types = entry.getKey();
            Iterator<IResourceType> iterator = types.iterator();
            IResourceType type1 = iterator.next();
            Set<Integer> type1Indices1 = problem.getIndicesForResourceType(type1);
            IResourceType type2 = iterator.next();
            Set<Integer> type2Indices2 = problem.getIndicesForResourceType(type2);
            int[] varIndices = entry.getValue();
            int deltaVarIndex = varIndices[0];
            double[] coefficients = new double[varCount];
            coefficients[deltaVarIndex] = 1.0;
            if (type1Indices1 == null || type2Indices2 == null) continue;
            for (int index : type1Indices1) {
                coefficients[index] = -1.0;
            }
            for (int index : type2Indices2) {
                coefficients[index] = 1.0;
            }
            LinearConstraint constraint = new LinearConstraint(coefficients, Relationship.LEQ, (double)0.01f);
            constraints.add(constraint);
            double[] absCoeff = new double[varCount];
            absCoeff[deltaVarIndex] = 1.0;
            absCoeff[varIndices[1]] = -1.0;
            absCoeff[varIndices[2]] = 1.0;
            LinearConstraint absConstraint = new LinearConstraint(absCoeff, Relationship.LEQ, (double)0.01f);
            constraints.add(absConstraint);
            double[] noNegCoeff1 = new double[varCount];
            noNegCoeff1[varIndices[1]] = 1.0;
            LinearConstraint noNeg1 = new LinearConstraint(noNegCoeff1, Relationship.GEQ, 0.0);
            constraints.add(noNeg1);
            double[] noNegCoeff2 = new double[varCount];
            noNegCoeff2[varIndices[2]] = 1.0;
            LinearConstraint noNeg2 = new LinearConstraint(noNegCoeff2, Relationship.GEQ, 0.0);
            constraints.add(noNeg2);
        }
        return constraints;
    }

    private LinkedHashMap<List<IResourceType>, int[]> getOrderedMap(Map<List<IResourceType>, int[]> balanceVarMap) {
        LinkedHashMap orderedMap = Maps.newLinkedHashMap();
        List<List<IResourceType>> orderedKeys = this.orderKeys(balanceVarMap.keySet());
        for (List<IResourceType> key : orderedKeys) {
            orderedMap.put(key, balanceVarMap.get(key));
        }
        return orderedMap;
    }

    private List<List<IResourceType>> orderKeys(Set<List<IResourceType>> set) {
        ArrayList keys = Lists.newArrayList(set);
        Collections.sort(keys, new Comparator<List<IResourceType>>(){

            @Override
            public int compare(List<IResourceType> o1, List<IResourceType> o2) {
                String o1SortKey = RmSortableUtils.getConcatenatedSortKeys(o1);
                String o2SortKey = RmSortableUtils.getConcatenatedSortKeys(o2);
                return o1SortKey.compareTo(o2SortKey);
            }
        });
        return keys;
    }

    private LinearConstraintSet createLinearConstraints(BalancedStageLpProblem problem) {
        ArrayList constraints = Lists.newArrayList();
        List<LinearConstraint> availabilityConstraints = this.createAvailabilityConstraintSet(problem);
        constraints.addAll(availabilityConstraints);
        List<LinearConstraint> openSkillConstraints = this.createOpenSkillConstraintSet(problem);
        constraints.addAll(openSkillConstraints);
        List<LinearConstraint> nonNeg = this.createNonNegConstraints(problem);
        constraints.addAll(nonNeg);
        constraints.add(this.createMinWorkLoadConstraint(problem));
        constraints.add(this.createMaxWorkLoadConstraint(problem));
        List<LinearConstraint> skillDistributionConstraints = this.createBalancingConstraints(problem);
        constraints.addAll(skillDistributionConstraints);
        return new LinearConstraintSet(constraints);
    }

    private List<LinearConstraint> createNonNegConstraints(BalancedStageLpProblem problem) {
        ArrayList constraints = Lists.newArrayList();
        for (int i = 0; i < problem.getAssignmentVariables().size(); ++i) {
            double[] coefficients = new double[problem.getVariableCount()];
            coefficients[i] = 1.0;
            LinearConstraint c = new LinearConstraint(coefficients, Relationship.GEQ, 0.0);
            constraints.add(c);
        }
        return constraints;
    }

    private LinearConstraint createMaxWorkLoadConstraint(BalancedStageLpProblem problem) {
        double[] coefficients = new double[problem.getVariableCount()];
        for (int i = 0; i < problem.getAssignmentVariableCount(); ++i) {
            coefficients[i] = 1.0;
        }
        LinearConstraint constraint = new LinearConstraint(coefficients, Relationship.LEQ, (double)problem.getMaxWorkLoad());
        return constraint;
    }

    private List<LinearConstraint> createOpenSkillConstraintSet(BalancedStageLpProblem problem) {
        Map<IResourceType, Set<Integer>> indicesMap = problem.getResourceTypeIndices();
        SortedPositivePrimitiveMap<IResourceType> limitsMap = RmCollectionUtils.getSortedMap(problem.getResourceTypeLimits());
        Relationship relationship = Relationship.LEQ;
        return ApacheUtils.createOrderedLinearConstraints(indicesMap, limitsMap, problem.getVariableCount(), relationship);
    }

    private List<LinearConstraint> createAvailabilityConstraintSet(BalancedStageLpProblem problem) {
        Map<IMutableResource, Set<Integer>> indicesMap = problem.getWorkResourceIndices();
        SortedPositivePrimitiveMap<IMutableResource> limitsMap = RmCollectionUtils.getSortedMap(problem.getWorkResourceLimits());
        Relationship relationship = Relationship.LEQ;
        return ApacheUtils.createOrderedLinearConstraints(indicesMap, limitsMap, problem.getVariableCount(), relationship);
    }
}

