/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ITeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.google.common.base.Optional;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PlannedCapacityTeamVelocityFunction
implements ITeamVelocityFunction {
    private final float defaultVelocity;
    private final WorkSlotsDefinition workSlotsDefinition;
    private final Map<Long, Double> capacityPerSprintId;

    public PlannedCapacityTeamVelocityFunction(float defaultVelocity, WorkSlotsDefinition workSlotsDefinition, Map<Long, Double> capacityPerSprintId) {
        this.defaultVelocity = defaultVelocity;
        this.capacityPerSprintId = capacityPerSprintId;
        this.workSlotsDefinition = workSlotsDefinition;
    }

    @Override
    public float getVelocity(int workSlotIndex) {
        IWorkSlot workSlot = this.workSlotsDefinition.getWorkSlotWithIndex(workSlotIndex);
        Optional<String> slotId = workSlot.tryGetId();
        if (!slotId.isPresent()) {
            return this.defaultVelocity;
        }
        Long lSlotId = Long.valueOf((String)slotId.get());
        if (this.capacityPerSprintId.containsKey(lSlotId)) {
            return this.capacityPerSprintId.get(lSlotId).floatValue();
        }
        return this.defaultVelocity;
    }

    @Override
    public boolean isPositiveEnding() {
        return true;
    }
}

