/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourceAvailability;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConstantStepWiseResourceAvailability
implements IStepWiseResourceAvailability {
    private final float availability;

    public ConstantStepWiseResourceAvailability(float availability) {
        this.availability = availability;
    }

    @Override
    public int getFirstRegularTimeStep() {
        return 0;
    }

    @Override
    public boolean isPositiveEnding() {
        return (double)this.availability > 0.0;
    }

    @Override
    public float getAvailability(int timeStep) {
        return this.availability;
    }

    @Override
    public float getAvailabilityInInterval(IIntegerInterval interval) {
        return this.availability * (float)interval.getLength();
    }

    @Override
    public List<IIntegerInterval> getAbsenceIntervals() {
        return Lists.newArrayList();
    }

    public String toString() {
        return "ConstantStepWiseResourceAvailability [availability=" + this.availability + "]";
    }
}

