/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.TimePlanRestriction;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class AbstractProcessingItem
implements IProcessingItem {
    protected final String id;
    private final int priority;
    private final AssignmentRestriction assignmentRestriction;
    protected final IAggregatedWorkPackage aggregatedWorkPackage;
    protected final String title;
    private final String sortKey;
    private final TimePlanRestriction temporalAssignmentRestriction;
    private final int releaseTime;

    AbstractProcessingItem(String id, String title, int priority, int releaseTime, IAggregatedWorkPackage aggregatedWorkPackage, AssignmentRestriction assignmentRestriction, TimePlanRestriction temporalAssignmentRestriction, String sortKey) {
        Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        Preconditions.checkNotNull((Object)aggregatedWorkPackage, (Object)"aggregated work package must not be null");
        Preconditions.checkNotNull((Object)sortKey, (Object)"sort key must not be null");
        this.id = id;
        this.priority = priority;
        this.releaseTime = releaseTime;
        this.aggregatedWorkPackage = aggregatedWorkPackage;
        this.assignmentRestriction = assignmentRestriction;
        this.title = title;
        this.sortKey = sortKey;
        this.temporalAssignmentRestriction = temporalAssignmentRestriction;
    }

    @Override
    public Optional<String> getTitle() {
        return Optional.fromNullable((Object)this.title);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    @Override
    public int getReleaseTime() {
        return this.releaseTime;
    }

    @Override
    public AssignmentRestriction getAssignmentRestriction() {
        return this.assignmentRestriction;
    }

    @Override
    public IAggregatedWorkPackage getWorkDemand() {
        return this.aggregatedWorkPackage;
    }

    @Override
    public List<IProcessingStage> getSpecifiedStages() {
        return this.aggregatedWorkPackage.getSpecifiedStages();
    }

    @Override
    public Optional<IProcessingStageWorkPackage> getWorkPackageForStage(IProcessingStage stage) {
        return this.aggregatedWorkPackage.getWorkPackageForStage(stage);
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.aggregatedWorkPackage.getResourceTypes();
    }

    @Override
    public String getStreamId() {
        return this.temporalAssignmentRestriction.getStreamId();
    }

    @Override
    public Optional<String> getFixedEpisodeId() {
        return this.temporalAssignmentRestriction.getFixedEpisodeId();
    }

    @Override
    public Optional<IEpisode> getFixedEpisode() {
        return this.temporalAssignmentRestriction.getFixedEpisode();
    }

    @Override
    public boolean isStrictlyAssigned() {
        return this.temporalAssignmentRestriction.isStrictlyAssigned();
    }

    @Override
    public List<IEpisode> getPossibleEpisodes() {
        return this.temporalAssignmentRestriction.getPossibleEpisodes();
    }
}

