/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceSupplyStatistics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IRoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ResourceSupplyStatistics;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RoadmapProblemStatistics
implements IRoadmapProblemStatistics {
    private final MutablePositivePrimitivesMap<IResourceType> workPackage;
    private final IResourceSupplyStatistics resourceSupplyStatistics;

    public RoadmapProblemStatistics(MutablePositivePrimitivesMap<IResourceType> workPackage, IResourceSupplyStatistics resourceSupplyStatistics) {
        this.workPackage = workPackage;
        this.resourceSupplyStatistics = resourceSupplyStatistics;
    }

    @Override
    public MutablePositivePrimitivesMap<IResourceType> getWorkPackage() {
        return this.workPackage;
    }

    @Override
    public IResourceSupplyStatistics getResourceSupplyStatistics() {
        return this.resourceSupplyStatistics;
    }

    public static IRoadmapProblemStatistics createInstance(Set<IProcessingItem> processingItems, Set<IResourceGroup> resourceGroups) {
        MutablePositivePrimitivesMap<IResourceType> overallMap = RoadmapProblemStatistics.calculateResourceDemands(processingItems);
        IResourceSupplyStatistics supplyStatistics = RoadmapProblemStatistics.calculateSupplyStatistics(resourceGroups);
        RoadmapProblemStatistics stats = new RoadmapProblemStatistics(overallMap, supplyStatistics);
        return stats;
    }

    private static IResourceSupplyStatistics calculateSupplyStatistics(Set<IResourceGroup> resourceGroups) {
        Map<IResourceType, Set<IWorkResource>> typeToResourcesMap = RoadmapProblemStatistics.getResourceTypeToResourcesMap(resourceGroups);
        ResourceSupplyStatistics stats = new ResourceSupplyStatistics(typeToResourcesMap);
        return stats;
    }

    private static Map<IResourceType, Set<IWorkResource>> getResourceTypeToResourcesMap(Set<IResourceGroup> resourceGroups) {
        HashMap typeToResourcesMap = Maps.newHashMap();
        for (IResourceGroup group : resourceGroups) {
            Set<IWorkResource> resources = group.getResources();
            for (IWorkResource resource : resources) {
                Set<IResourceType> availableTypes = resource.getResourceTypes();
                for (IResourceType type : availableTypes) {
                    RmUtils.addToKeyedSets(typeToResourcesMap, type, resource);
                }
            }
        }
        return typeToResourcesMap;
    }

    private static MutablePositivePrimitivesMap<IResourceType> calculateResourceDemands(Set<IProcessingItem> processingItems) {
        MutablePositivePrimitivesMap<IResourceType> sumMap = RmCollectionUtils.newMutablePositiveMap();
        for (IProcessingItem unstructuredItem : processingItems) {
            IAggregatedWorkPackage aggregatedWorkDemand = unstructuredItem.getWorkDemand();
            PositivePrimitivesMap<IResourceType> amounts = aggregatedWorkDemand.getPositiveTypeAmounts();
            sumMap.add(amounts);
        }
        return sumMap;
    }
}

