/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.SubAssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositiveTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImmutableAssignmentCandidate
implements AssignmentCandidate {
    private final List<Integer> timeIndices;
    private final PrimitivesMap<AssignmentResource> costs;
    private final PositivePrimitivesMap<AssignmentResource> aggregatedAvailabilities;
    private final String sortKey;
    private final boolean syncStart;
    private final List<SubAssignmentCandidate> subAssignmentCandidates;
    private final PositivePrimitivesMap<IResourceType> overallDemand;
    private final boolean hasLimitedResources;

    public ImmutableAssignmentCandidate(List<SubAssignmentCandidate> subAssignmentCandidates, List<Integer> timeIndices, PrimitivesMap<AssignmentResource> costs, PositivePrimitivesMap<AssignmentResource> aggregatedAvailabilities, String sortKey, boolean syncStart, PositivePrimitivesMap<IResourceType> overallDemand) {
        this.subAssignmentCandidates = subAssignmentCandidates;
        this.timeIndices = timeIndices;
        this.costs = costs;
        this.aggregatedAvailabilities = aggregatedAvailabilities;
        this.sortKey = sortKey;
        this.syncStart = syncStart;
        this.overallDemand = overallDemand;
        this.hasLimitedResources = ImmutableAssignmentCandidate.hasLimitedResource(costs.keySet());
    }

    private static boolean hasLimitedResource(Set<AssignmentResource> assignmentResources) {
        for (AssignmentResource assignmentResource : assignmentResources) {
            if (!assignmentResource.isLimitedAvailable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getTimeIndices() {
        return this.timeIndices;
    }

    @Override
    public PositivePrimitivesMap<AssignmentResource> getAggregatedAvailabilities() {
        return this.aggregatedAvailabilities;
    }

    @Override
    public PrimitivesMap<AssignmentResource> getResourceCosts() {
        return this.costs;
    }

    @Override
    public int getLatestTime() {
        return this.timeIndices.get(this.timeIndices.size() - 1);
    }

    @Override
    public List<SubAssignmentCandidate> getSubAssignmentCandidates() {
        return this.subAssignmentCandidates;
    }

    @Override
    public boolean isSyncStart() {
        return this.syncStart;
    }

    @Override
    public boolean isEveryoneAvailableFree() {
        for (AssignmentResource resource : this.costs.keySet()) {
            if (!resource.isAvailableInWorkSlot(this.getLatestTime()) || !resource.isWorkScheduled(this.getLatestTime())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSomeoneAvailableFree() {
        for (AssignmentResource resource : this.costs.keySet()) {
            if (!resource.isAvailableInWorkSlot(this.getLatestTime()) || resource.isWorkScheduled(this.getLatestTime())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNoOneAvailable() {
        for (AssignmentResource resource : this.costs.keySet()) {
            if (!resource.isAvailableInWorkSlot(this.getLatestTime())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<AssignmentResource> getLimitedAvailableResources() {
        return Sets.filter(this.costs.keySet(), (Predicate)new Predicate<AssignmentResource>(){

            public boolean apply(AssignmentResource assignmentResource) {
                return assignmentResource.isLimitedAvailable();
            }
        });
    }

    @Override
    public boolean areLimitedResourcesGone() {
        if (!this.hasLimitedResources) {
            return true;
        }
        int lastConsideredTime = this.timeIndices.get(this.timeIndices.size() - 1);
        for (AssignmentResource resource : this.costs.keySet()) {
            if (resource.getFirstRegularTimeIndex() <= lastConsideredTime) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<ImmutableNonEmptyPositivePrimitivesMap<IResourceType>> getDemandsOfLimitedResources() {
        final HashSet limitedTypeIds = Sets.newHashSet();
        for (AssignmentResource limitedResource : this.costs.keySet()) {
            if (!limitedResource.isLimitedAvailable()) continue;
            limitedTypeIds.addAll(limitedResource.getTypes());
        }
        for (AssignmentResource resource : this.costs.keySet()) {
            if (resource.isLimitedAvailable()) continue;
            limitedTypeIds.removeAll(resource.getTypes());
        }
        PositivePrimitivesMap<IResourceType> filtered = RmCollectionUtils.filterKeys(this.overallDemand, new Predicate<IResourceType>(){

            public boolean apply(IResourceType input) {
                return limitedTypeIds.contains(input);
            }
        });
        return ImmutableNonEmptyPositiveTroveMap.tryCreate(filtered);
    }

    @Override
    public boolean isStaticallyUnsolvable() {
        return this.isOverallAvailabilityLowerThanOverallDemand();
    }

    private boolean isOverallAvailabilityLowerThanOverallDemand() {
        float availability = this.aggregatedAvailabilities.getValueSum();
        for (SubAssignmentCandidate subAssignmentCandidate : this.subAssignmentCandidates) {
            if (!((availability -= subAssignmentCandidate.getDemand().getValueSum()) < 0.0f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }
}

