/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.IIdentifiable;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class RmIdentifiableUtils {
    private static final Log LOGGER = Log.with(RmIdentifiableUtils.class);

    private RmIdentifiableUtils() {
    }

    public static Set<String> getIds(@Nullable Collection<? extends IIdentifiable> collection) {
        if (collection == null) {
            return Collections.EMPTY_SET;
        }
        HashSet ids = Sets.newHashSetWithExpectedSize((int)collection.size());
        for (IIdentifiable iIdentifiable : collection) {
            ids.add(iIdentifiable.getId());
        }
        return ids;
    }

    public static List<String> getOrderedIds(List<? extends IIdentifiable> identifiables) {
        ArrayList ids = Lists.newArrayListWithCapacity((int)identifiables.size());
        for (IIdentifiable iIdentifiable : identifiables) {
            ids.add(iIdentifiable.getId());
        }
        return ids;
    }

    public static <T extends IIdentifiable> List<T> sortById(Collection<T> collection) {
        Preconditions.checkNotNull(collection, (Object)"collection must not be null");
        ArrayList list = Lists.newArrayList(collection);
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return list;
    }

    public static <T extends IIdentifiable> BiMap<String, T> createIdMap(Collection<T> identifiables) {
        Preconditions.checkNotNull(identifiables, (Object)"set of identifiables must not be null");
        HashBiMap map = HashBiMap.create((int)identifiables.size());
        for (IIdentifiable identifiable : identifiables) {
            String id = identifiable.getId();
            IIdentifiable previous = (IIdentifiable)map.put((Object)id, (Object)identifiable);
            if (previous == null) continue;
            LOGGER.error("encountered duplicate IDs for %s and %s", identifiable, previous);
            throw new IllegalArgumentException("duplicate ID: " + id);
        }
        return map;
    }

    public static <T extends IIdentifiable> List<T> getElementsWithoutIds(Set<String> ids, List<T> elements) {
        Preconditions.checkNotNull(ids, (Object)"id set must not be null");
        Preconditions.checkNotNull(elements, (Object)"elements list must not be null");
        ArrayList filteredElements = Lists.newArrayListWithCapacity((int)elements.size());
        for (IIdentifiable element : elements) {
            if (ids.contains(element.getId())) continue;
            filteredElements.add(element);
        }
        return filteredElements;
    }

    public static <T extends IIdentifiable> Set<T> getElementsWithIds(Set<String> ids, Set<T> elements) {
        HashSet filteredElements = Sets.newHashSet();
        for (IIdentifiable element : elements) {
            if (!ids.contains(element.getId())) continue;
            filteredElements.add(element);
        }
        return filteredElements;
    }

    public static <T extends IIdentifiable> Set<T> getElementsWithId(String id, Set<T> elements) {
        return RmIdentifiableUtils.getElementsWithIds(Sets.newHashSet((Object[])new String[]{id}), elements);
    }

    public static <T> Set<T> getElementsWithIds(Collection<String> ids, Map<String, T> itemMap) {
        HashSet elements = Sets.newHashSet();
        for (String id : ids) {
            T element = itemMap.get(id);
            if (element == null) continue;
            elements.add(element);
        }
        return elements;
    }

    public static <T extends IIdentifiable> Optional<T> tryFindElementWithId(String id, Collection<T> set) {
        for (IIdentifiable element : set) {
            if (!id.equals(element.getId())) continue;
            return Optional.of((Object)element);
        }
        return Optional.absent();
    }

    public static <K extends IIdentifiable, T> Map<String, T> getStringKeyedMap(Map<K, T> identifiableMap) {
        Preconditions.checkNotNull(identifiableMap, (Object)"map must not be null");
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry<K, T> identifiableEntry : identifiableMap.entrySet()) {
            stringMap.put(((IIdentifiable)identifiableEntry.getKey()).getId(), identifiableEntry.getValue());
        }
        return stringMap;
    }

    public static <K extends IIdentifiable> int getIndex(String id, List<K> identifiables) {
        for (int i = 0; i < identifiables.size(); ++i) {
            if (!id.equals(((IIdentifiable)identifiables.get(i)).getId())) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public static <K extends IIdentifiable, V extends IIdentifiable> Map<String, Set<String>> getIdsMap(Map<K, Set<V>> map) {
        HashMap ids = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry<K, Set<V>> entry : map.entrySet()) {
            ids.put(((IIdentifiable)entry.getKey()).getId(), RmIdentifiableUtils.getIds((Collection<? extends IIdentifiable>)entry.getValue()));
        }
        return ids;
    }
}

