/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.ISortable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RmSortableUtils {
    public static final Comparator<ISortable> COMPARATOR = new Comparator<ISortable>(){

        @Override
        public int compare(ISortable o1, ISortable o2) {
            return o1.getSortKey().compareTo(o2.getSortKey());
        }
    };

    public static <K extends ISortable, V> LinkedHashMap<K, V> getLinkedHashMap(Map<K, V> map) {
        Preconditions.checkNotNull(map, (Object)"map to sort must not be null");
        LinkedHashMap orderedMap = Maps.newLinkedHashMap();
        List<ISortable> sortedKeys = RmSortableUtils.sort(map.keySet());
        for (ISortable key : sortedKeys) {
            orderedMap.put(key, map.get(key));
        }
        return orderedMap;
    }

    public static <T extends ISortable> String getConcatenatedSortKeys(List<T> sortables) {
        Preconditions.checkNotNull(sortables, (Object)"sortable list must not be null");
        StringBuilder sortKey = new StringBuilder();
        for (ISortable type : sortables) {
            sortKey.append(type.getSortKey()).append("@");
        }
        return sortKey.toString();
    }

    public static <T extends ISortable> List<T> sort(Collection<T> collection) {
        Preconditions.checkNotNull(collection, (Object)"collection must not be null");
        ArrayList list = Lists.newArrayList(collection);
        Collections.sort(list, COMPARATOR);
        return list;
    }
}

