/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.NumberExpression;
import java.util.List;

public class NumberOperation<T extends Number>
extends NumberExpression<T>
implements Operation<T> {
    private static final long serialVersionUID = -3593040852095778453L;
    private final OperationImpl<T> opMixin;

    public static <D extends Number> NumberExpression<D> create(Class<? extends D> type, Operator<? super D> op, Expression<?> one) {
        return new NumberOperation<D>(type, op, ImmutableList.of(one));
    }

    public static <D extends Number> NumberExpression<D> create(Class<? extends D> type, Operator<? super D> op, Expression<?> one, Expression<?> two) {
        return new NumberOperation<D>(type, op, ImmutableList.of(one, two));
    }

    public static <D extends Number> NumberExpression<D> create(Class<? extends D> type, Operator<? super D> op, Expression<?> ... args) {
        return new NumberOperation<D>(type, op, args);
    }

    protected NumberOperation(Class<? extends T> type, Operator<? super T> op, Expression<?> ... args) {
        this(type, op, ImmutableList.copyOf((Object[])args));
    }

    protected NumberOperation(Class<? extends T> type, Operator<? super T> op, ImmutableList<Expression<?>> args) {
        super(new OperationImpl<T>(type, op, args));
        this.opMixin = (OperationImpl)this.mixin;
    }

    @Override
    public NumberExpression<T> negate() {
        if (this.opMixin.getOperator() == Ops.NEGATE) {
            return (NumberExpression)this.opMixin.getArg(0);
        }
        return super.negate();
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this.opMixin, context);
    }

    @Override
    public Expression<?> getArg(int index) {
        return this.opMixin.getArg(index);
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.opMixin.getArgs();
    }

    @Override
    public Operator<? super T> getOperator() {
        return this.opMixin.getOperator();
    }
}

