/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.settings;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.generator.settings.ISkillConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.ISkillPersistency;
import com.radiantminds.roadmap.common.data.generator.settings.IStageConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.IStagePersistency;
import com.radiantminds.roadmap.common.data.generator.settings.SkillsPersistency;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSkillPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.rest.entities.skills.RestStage;
import java.util.List;

public class StagePersistency
implements IStagePersistency {
    private static final Log LOGGER = Log.with(StagePersistency.class);
    private final PortfolioStagePersistence stagePersistency;
    private final ISkillPersistency skillPersistency;

    public StagePersistency(PortfolioStagePersistence stagePersistence, PortfolioSkillPersistence skillPersistence) {
        this.stagePersistency = stagePersistence;
        this.skillPersistency = new SkillsPersistency(skillPersistence);
    }

    StagePersistency(PortfolioStagePersistence stagePersistency, ISkillPersistency skillPersistency) {
        this.stagePersistency = stagePersistency;
        this.skillPersistency = skillPersistency;
    }

    @Override
    public IStage persistStage(IStageConfiguration configuration, IPlan plan) throws PersistenceException {
        LOGGER.debug("persist stage from configuration: %s", configuration);
        RestStage stage = new RestStage(null, null, null, null, Lists.newArrayList());
        String title = configuration.getTitle();
        stage.setTitle(title);
        Optional<Double> percentage = configuration.getPercentage();
        if (percentage.isPresent()) {
            stage.setPercentage((Double)percentage.get());
        }
        Optional<String> colorString = configuration.getColorAsString();
        stage.setColor((String)colorString.orNull());
        stage.setPlan(plan);
        IStage persistedStage = this.stagePersistency.persist(stage);
        LOGGER.debug("persisted stage: %s", persistedStage);
        List skillConfigurations = Lists.reverse(configuration.getSkillConfigurations());
        for (ISkillConfiguration skillConfiguration : skillConfigurations) {
            this.skillPersistency.persistSkill(skillConfiguration, persistedStage);
        }
        return persistedStage;
    }
}

