/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.teams;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.generator.teams.AbilityPersistency;
import com.radiantminds.roadmap.common.data.generator.teams.AbsencePersistency;
import com.radiantminds.roadmap.common.data.generator.teams.AvailabilityPersistency;
import com.radiantminds.roadmap.common.data.generator.teams.IAbilityConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IAbilityPersistency;
import com.radiantminds.roadmap.common.data.generator.teams.IAbsenceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IAvailabilityConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IPresenceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IResourceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.PresencePersistency;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbilityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbsenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAvailabilityIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPresenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.rest.entities.people.RestPerson;
import com.radiantminds.roadmap.common.rest.entities.people.RestResource;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class ResourcePersistency {
    private PortfolioResourcePersistence persistency;
    private final PortfolioPersonPersistence personsPersistency;
    private final IAbilityPersistency abilityPersistency;
    private final PresencePersistency presencePersistency;
    private final AbsencePersistency absencePersistency;
    private final AvailabilityPersistency availabilityPersistency;

    public ResourcePersistency(PortfolioPersonPersistence personPersistence, PortfolioAbilityPersistence abilityPersistence, PortfolioResourcePersistence resourcePersistence, PortfolioAvailabilityIntervalPersistence availabilityIntervalPersistence, PortfolioPresenceIntervalPersistence presenceIntervalPersistence, PortfolioAbsenceIntervalPersistence absenceIntervalPersistence) {
        this.persistency = resourcePersistence;
        this.personsPersistency = personPersistence;
        this.abilityPersistency = new AbilityPersistency(abilityPersistence);
        this.presencePersistency = new PresencePersistency(presenceIntervalPersistence);
        this.absencePersistency = new AbsencePersistency(absenceIntervalPersistence);
        this.availabilityPersistency = new AvailabilityPersistency(availabilityIntervalPersistence);
    }

    public IResource persistResource(IResourceConfiguration configuration, ITeam team, IPlan plan) throws PersistenceException, SQLException {
        RestResource resource = new RestResource(null, null);
        RestPerson person = new RestPerson(null, null, null, null);
        person.setPlan(plan);
        person.setTitle(configuration.getTitle());
        IPerson persistedPerson = this.personsPersistency.persist(person);
        Set<IAbilityConfiguration> abilityConfigurations = configuration.getAbilityConfigurations();
        for (IAbilityConfiguration iAbilityConfiguration : abilityConfigurations) {
            this.abilityPersistency.persistAbility(iAbilityConfiguration, persistedPerson, plan);
        }
        Set<IPresenceConfiguration> presenceConfigurations = configuration.getPresenceConfigurations();
        for (IPresenceConfiguration iPresenceConfiguration : presenceConfigurations) {
            this.presencePersistency.persistPresence(iPresenceConfiguration, persistedPerson, plan);
        }
        Set<IAbsenceConfiguration> set = configuration.getAbsenceConfigurations();
        for (IAbsenceConfiguration absenceConfiguration : set) {
            this.absencePersistency.persistAbsence(absenceConfiguration, persistedPerson, plan);
        }
        resource.setPerson(persistedPerson);
        resource.setTeam(team);
        Optional<Double> optional = configuration.getAvailability();
        if (optional.isPresent()) {
            resource.setAvailability((Double)optional.get());
        }
        IResource persistedResource = this.persistency.persist(resource);
        List<IAvailabilityConfiguration> availabilityConfigurations = configuration.getAvailabilityConfigurations();
        for (IAvailabilityConfiguration availabilityConfiguration : Lists.reverse(availabilityConfigurations)) {
            this.availabilityPersistency.persistAvailability(availabilityConfiguration, persistedResource, plan);
        }
        return persistedResource;
    }
}

