/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.teams;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.generator.teams.IResourceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ISprintConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamConfiguration;
import java.util.List;

public class TeamConfiguration
implements ITeamConfiguration {
    private final String title;
    private final PlanningMode planningMode;
    private final List<IResourceConfiguration> resourceConfigurations;
    private final List<ISprintConfiguration> sprintConfigurations;

    public TeamConfiguration(String title, List<IResourceConfiguration> resourceConfigurations) {
        this(title, PlanningMode.Scrum, resourceConfigurations, Lists.newArrayList());
    }

    public TeamConfiguration(String title, PlanningMode planningMode, List<IResourceConfiguration> resourceConfigurations) {
        this(title, planningMode, resourceConfigurations, Lists.newArrayList());
    }

    public TeamConfiguration(String title, List<IResourceConfiguration> resourceConfigurations, List<ISprintConfiguration> sprintConfigurations) {
        this(title, PlanningMode.Scrum, resourceConfigurations, sprintConfigurations);
    }

    public TeamConfiguration(String title, PlanningMode planningMode, List<IResourceConfiguration> resourceConfigurations, List<ISprintConfiguration> sprintConfigurations) {
        this.title = title;
        this.planningMode = planningMode;
        this.resourceConfigurations = resourceConfigurations;
        this.sprintConfigurations = sprintConfigurations;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<IResourceConfiguration> getResourceConfigurations() {
        return this.resourceConfigurations;
    }

    @Override
    public List<ISprintConfiguration> getSprintConfigurations() {
        return this.sprintConfigurations;
    }

    @Override
    public PlanningMode getPlanningMode() {
        return this.planningMode;
    }
}

