/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.integrity.rank;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ISortable;
import com.radiantminds.roadmap.common.data.integrity.DatabaseIntegrityChecker;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOAbsence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOAvailability;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOPresence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.themes.AOTheme;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

abstract class BaseSortableIntegrityChecker
extends BaseAOPersistenceSQL
implements DatabaseIntegrityChecker {
    private final Log logger;

    BaseSortableIntegrityChecker(Log logger, ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.logger = logger;
    }

    protected abstract void checkClassForRankIntegrity(Connection var1, String var2, Class<? extends ISortable> var3) throws SQLException;

    protected List<Class<? extends ISortable>> getApplicableTables() {
        return Lists.newArrayList((Object[])new Class[]{AOStream.class, AOResource.class, AOTeam.class, AOSkill.class, AOStage.class, AORelease.class, AOTheme.class, AOAvailability.class, AOPresence.class, AOAbsence.class});
    }

    @Override
    public void checkAndFix(String planId, Connection connection) throws SQLException {
        for (Class<? extends ISortable> sortable : this.getApplicableTables()) {
            try {
                this.logger.debug("Checking sort order integrity of %s", sortable);
                this.checkClassForRankIntegrity(connection, planId, sortable);
            }
            catch (Exception ex) {
                this.logger.debug("Failed to check/fix integrity of %s", sortable);
            }
        }
    }
}

