/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.dbutils.DbUtils;

public class DBResetSQL
extends BaseAOPersistenceSQL {
    private static final Log LOGGER = Log.with(DBResetSQL.class);
    private final ActiveObjectsUtilities activeObjectsUtilities;
    private static String mySqlCachedQuery = null;

    public DBResetSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.activeObjectsUtilities = activeObjectsUtilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws Exception {
        block10: {
            Connection conn = this.activeObjectsUtilities.getOrCreateConnection();
            try {
                String dbType = conn.getMetaData().getDatabaseProductName().toLowerCase();
                LOGGER.info("Resetting Database: " + dbType, new Object[0]);
                if (dbType.contains("hsql")) {
                    int major = conn.getMetaData().getDatabaseMajorVersion();
                    if (major < 2) {
                        this.resetHsqlOld();
                    } else {
                        this.resetHsql();
                    }
                    break block10;
                }
                if (dbType.contains("mysql")) {
                    this.resetMySQL(conn);
                    break block10;
                }
                if (dbType.contains("postgresql")) {
                    this.resetPostgreSQL(conn);
                    break block10;
                }
                if (dbType.contains("microsoft sql server")) {
                    this.resetSQLServer();
                    break block10;
                }
                if (dbType.contains("oracle")) {
                    this.resetOracle();
                    break block10;
                }
                throw new RuntimeException("Unknow database type '" + dbType + "'. Unable to reset.");
            }
            finally {
                DbUtils.closeQuietly(conn);
            }
        }
    }

    private void resetHsql() throws Exception {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.raw("TRUNCATE SCHEMA public RESTART IDENTITY AND COMMIT NO CHECK");
            }
        });
    }

    private void resetHsqlOld() throws Exception {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.raw("SET REFERENTIAL_INTEGRITY FALSE");
            }
        });
        Set<String> tables = this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.raw("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.system_tables WHERE TABLE_TYPE = 'TABLE' and TABLE_SCHEM = 'PUBLIC' ");
            }

            @Override
            public Set<String> handleResult(ResultSet rs) throws Exception {
                HashSet<String> tables = new HashSet<String>();
                while (rs.next()) {
                    if (rs.getString(1).startsWith("DUAL_")) continue;
                    tables.add(rs.getString(1));
                }
                return tables;
            }
        });
        for (final String table : tables) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.raw("DELETE FROM " + table);
                }
            });
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    if (!"AODOOR_STOP".equals(table)) {
                        generator.raw("ALTER TABLE " + table + " ALTER COLUMN ID_OTHER RESTART WITH 1");
                    }
                }
            });
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.raw("SET REFERENTIAL_INTEGRITY TRUE");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPostgreSQL(Connection conn) throws Exception {
        String query = "CREATE OR REPLACE FUNCTION make_plpgsql()\n  RETURNS VOID\nLANGUAGE SQL\nAS $$\nCREATE LANGUAGE plpgsql;\n$$;\nSELECT CASE\n       WHEN EXISTS(\n           SELECT 1\n           FROM pg_catalog.pg_language\n           WHERE lanname = 'plpgsql'\n       )\n         THEN NULL\n       ELSE make_plpgsql() END;\nDROP FUNCTION make_plpgsql();\nCREATE OR REPLACE FUNCTION truncAll()\n  RETURNS VOID\n  AS $$\nBEGIN\n    BEGIN\n       EXECUTE (\n          SELECT 'TRUNCATE TABLE '\n                 || array_to_string(array_agg(quote_ident(t.tablename)), ', ')\n                 || ' RESTART IDENTITY CASCADE'\n          FROM   pg_tables t\n          WHERE  t.schemaname = 'public'\n       );\n    END;\nEND$$ LANGUAGE plpgsql;\nSELECT truncAll();\nDROP FUNCTION truncAll();";
        Statement statement = conn.createStatement();
        try {
            statement.execute(query);
        }
        finally {
            DbUtils.closeQuietly(statement);
        }
    }

    private void resetSQLServer() throws Exception {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.raw("EXEC sp_MSForEachTable \"ALTER TABLE ? NOCHECK CONSTRAINT all\"\nEXEC sp_MSForEachTable \"DELETE FROM ?\"\nEXEC sp_MSForEachTable \"DBCC CHECKIDENT ( '?', RESEED, 0)\"EXEC sp_MSForEachTable \"ALTER TABLE ? WITH CHECK CHECK CONSTRAINT all\"\n");
            }
        });
    }

    private void resetMySQL(final Connection conn) throws Exception {
        if (mySqlCachedQuery == null) {
            mySqlCachedQuery = this.sql(new IQuery<String>(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.raw("SELECT Concat('DELETE FROM ', TABLE_NAME, '; '), Concat('ALTER TABLE ', TABLE_NAME, ' auto_increment=1; ') FROM INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = '" + conn.getCatalog() + "';");
                }

                @Override
                public String handleResult(ResultSet set) throws Exception {
                    String retVal = "SET FOREIGN_KEY_CHECKS = 0;";
                    ArrayList deleteStrings = Lists.newArrayList();
                    ArrayList autoIncrementStrings = Lists.newArrayList();
                    while (set.next()) {
                        deleteStrings.add(set.getString(1));
                        autoIncrementStrings.add(set.getString(2));
                    }
                    for (String deleteString : deleteStrings) {
                        retVal = retVal + deleteString;
                    }
                    for (String autoIncrementString : autoIncrementStrings) {
                        retVal = retVal + autoIncrementString;
                    }
                    retVal = retVal + "SET FOREIGN_KEY_CHECKS = 1;";
                    return retVal;
                }
            });
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.raw(mySqlCachedQuery);
            }
        });
    }

    private void resetOracle() throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.raw("BEGIN reset_user_tables(); END;");
            }
        });
    }
}

