/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.sql;

import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.AOCustomWording;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CustomWordingSQL
extends BaseAOPersistenceSQL {
    public CustomWordingSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public Map<String, String> getCustomWordings() throws SQLException {
        return this.sql(new IQuery<Map<String, String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOCustomWording.class, "w").select().col("w", "wordKey").col("w", "wordValue").from("w");
            }

            @Override
            public Map<String, String> handleResult(ResultSet result) throws Exception {
                HashMap retVal = Maps.newHashMap();
                while (result.next()) {
                    String key = BaseAOPersistenceSQL.getString(result, 1);
                    String wording = BaseAOPersistenceSQL.getString(result, 2);
                    retVal.put(key, wording);
                }
                return retVal;
            }
        });
    }

    public void remove(final String key) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOCustomWording.class, "w").deleteFrom().tableNoAlias("w").where().colNoAlias("w", "wordKey").eq().str(key);
            }
        });
    }
}

