/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.IAvailability;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiableImpl;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import java.util.List;

public class AOResourceImpl
extends AOIdentifiableImpl {
    private final AOResource data;

    public AOResourceImpl(AOResource data) {
        super(data);
        this.data = data;
    }

    public ITeam getTeam() {
        return this.data.getAOTeam();
    }

    public IPerson getPerson() {
        return this.data.getAOPerson();
    }

    public void setTeam(ITeam team) {
        this.setExplicitRelation(team, AOTeam.class, new AOIdentifiableImpl.IRelationCallback<AOTeam>(){

            @Override
            public void apply(AOTeam dbTeam) {
                AOResourceImpl.this.data.setOrderRangeIdentifier("team-" + dbTeam.getId());
                AOResourceImpl.this.data.setAOTeam(dbTeam);
            }
        });
    }

    public void setPerson(IPerson person) {
        this.setExplicitRelation(person, AOPerson.class, new AOIdentifiableImpl.IRelationCallback<AOPerson>(){

            @Override
            public void apply(AOPerson dbPerson) {
                AOResourceImpl.this.data.setAOPerson(dbPerson);
            }
        });
    }

    public List<IAvailability> getAvailabilityIntervals() {
        return Lists.newArrayList((Object[])this.data.getAOAvailabilityIntervals());
    }
}

