/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.releases;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiableImpl;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import java.util.List;

public class AOReleaseImpl
extends AOIdentifiableImpl<AORelease> {
    private final AORelease data;

    public AOReleaseImpl(AORelease data) {
        super(data);
        this.data = data;
    }

    public List<IWorkItem> getWorkItems() {
        return Lists.newArrayList((Object[])this.data.getAOWorkItems());
    }

    public IStream getStream() {
        return this.data.getAOStream();
    }

    public void setStream(IStream stream) {
        this.setExplicitRelation(stream, AOStream.class, new AOIdentifiableImpl.IRelationCallback<AOStream>(){

            @Override
            public void apply(AOStream dbStream) {
                AOReleaseImpl.this.data.setOrderRangeIdentifier("stream-" + dbStream.getId());
                AOReleaseImpl.this.data.setAOStream(dbStream);
            }
        });
    }

    public Optional<Long> getFixedEndDate() {
        return Optional.fromNullable((Object)this.data.getAOFixedEndDate());
    }

    public void setFixedEndDate(Long date) {
        this.data.setAOFixedEndDate(date);
    }

    public Optional<Long> getFixedStartDate() {
        return Optional.fromNullable((Object)this.data.getAOFixedStartDate());
    }

    public void setFixedStartDate(Long date) {
        this.data.setAOFixedStartDate(date);
    }

    public Optional<Long> getDeltaStartDate() {
        return Optional.fromNullable((Object)this.data.getAODeltaStartDate());
    }

    public void setDeltaStartDate(Long date) {
        this.data.setAODeltaStartDate(date);
    }

    public List<IExtensionLink> getExtensionLinks() {
        return Lists.newArrayList((Object[])this.data.getAOExtensionLinks());
    }
}

