/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.NewTreeAdaptionResult;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.VersionedId;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.WorkItemMoveResult;
import java.util.Collections;
import java.util.Set;

class WorkItemMoveResultImpl
implements WorkItemMoveResult {
    private final String inheritedThemeId;
    private final Set<String> themeInheritingItemIds;
    private final VersionedId item;
    private final VersionedId newParent;
    private final VersionedId oldParent;

    public WorkItemMoveResultImpl(VersionedId item, VersionedId newParent, VersionedId oldParent, NewTreeAdaptionResult adaptionResult) {
        this.item = item;
        this.newParent = newParent;
        this.oldParent = oldParent;
        this.inheritedThemeId = (String)adaptionResult.getThemeId().orNull();
        this.themeInheritingItemIds = adaptionResult.getInheritingItems();
    }

    @Override
    public String getWorkItemId() {
        return this.item.getId();
    }

    @Override
    public String getOldParentId() {
        return this.oldParent.getId();
    }

    @Override
    public String getNewParentId() {
        return this.newParent.getId();
    }

    @Override
    public Optional<Long> getWorkItemVersion() {
        return this.item.getVersion();
    }

    @Override
    public Optional<Long> getNewParentVersion() {
        return this.newParent.getVersion();
    }

    @Override
    public Optional<Long> getOldParentVersion() {
        return this.oldParent.getVersion();
    }

    @Override
    public Optional<String> getInheritedThemeId() {
        return Optional.fromNullable((Object)this.inheritedThemeId);
    }

    @Override
    public Set<String> getThemeInheritingItemIds() {
        return Collections.unmodifiableSet(this.themeInheritingItemIds);
    }
}

