/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.modifiers;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.BaseLegacyDocumentModifier;
import com.radiantminds.roadmap.common.utils.JPOVersion;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SchedulingVersionModifier
extends BaseLegacyDocumentModifier {
    private static final Log LOGGER = Log.with(SchedulingVersionModifier.class);

    @Override
    public JPOVersion isRelevantBeforeVersion() {
        return new JPOVersion(1, 9, 0);
    }

    @Override
    public void modify(List<AOTableImportData> importData) {
        Optional<AOTableImportData> planData = this.getDataFor(AOPlan.class, importData);
        if (!planData.isPresent()) {
            return;
        }
        Map<String, String> plan = ((AOTableImportData)planData.get()).getRows().get(0);
        if (!plan.containsKey("schedulingversion")) {
            String planVersion = plan.get("planversion");
            LOGGER.info("Legacy import: Setting scheduling version to plan version, %s.", planVersion);
            plan.put("schedulingversion", planVersion);
        }
    }
}

