/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade.tasks;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlanConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.BaseUpgradeTask;
import java.sql.Connection;
import org.apache.commons.dbutils.DbUtils;

public class U_01900_SyncSettingsUpgradeTask
extends BaseUpgradeTask {
    @Override
    protected int getDataModelVersion() {
        return 1900;
    }

    @Override
    protected void performUpgrade(ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) throws Exception {
        new UpgradeSQL(utils).perform(this.getOrCreateConnection(utils.getAccessor()));
    }

    @Override
    protected boolean migrateOnUpgrade() {
        return true;
    }

    private static class UpgradeSQL
    extends BaseAOPersistenceSQL {
        public UpgradeSQL(ActiveObjectsUtilities utils) {
            super(utils);
        }

        public void perform(Connection connection) throws Exception {
            connection.setAutoCommit(false);
            try {
                this.sql(new IUpdate(){

                    @Override
                    public void sql(AOQueryGenerator generator) throws Exception {
                        generator.withTable(AOPlanConfiguration.class, "c").update().tableNoAlias("c").set().colNoAlias("c", "syncStories").eq().bool(true).where().colNoAlias("c", "storySyncMode").neq().str("none");
                    }
                }, connection, false);
                this.sql(new IUpdate(){

                    @Override
                    public void sql(AOQueryGenerator generator) throws Exception {
                        generator.withTable(AOPlanConfiguration.class, "c").update().tableNoAlias("c").set().colNoAlias("c", "syncEpics").eq().bool(true).where().colNoAlias("c", "epicSyncMode").neq().str("none");
                    }
                }, connection, false);
                this.sql(new IUpdate(){

                    @Override
                    public void sql(AOQueryGenerator generator) throws Exception {
                        generator.withTable(AOPlanConfiguration.class, "c").update().tableNoAlias("c").set().colNoAlias("c", "syncInitiatives").eq().bool(true).where().colNoAlias("c", "initiativeSyncMode").neq().str("none");
                    }
                }, connection, false);
            }
            finally {
                connection.commit();
                DbUtils.closeQuietly(connection);
            }
        }
    }
}

