/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.analytics;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class WorkItemStatistics {
    private final Map<SchedulingWorkItem, Set<Double>> epicEstimates;
    private final Map<SchedulingWorkItem, Set<Double>> storyEstimates;
    private final long dependencyCnt;
    private final long releaseAssignmentCnt;
    private final long teamAssignmentCnt;
    private final long resourceAssignmentCnt;

    private WorkItemStatistics(Map<SchedulingWorkItem, Set<Double>> epicEstimates, Map<SchedulingWorkItem, Set<Double>> storyEstimates, long dependencyCnt, long releaseAssignmentCnt, long teamAssignmentCnt, long resourceAssignmentCnt) {
        this.epicEstimates = epicEstimates;
        this.storyEstimates = storyEstimates;
        this.dependencyCnt = dependencyCnt;
        this.releaseAssignmentCnt = releaseAssignmentCnt;
        this.teamAssignmentCnt = teamAssignmentCnt;
        this.resourceAssignmentCnt = resourceAssignmentCnt;
    }

    static WorkItemStatistics create(SchedulingPlan plan) {
        HashMap epicEstimates = Maps.newHashMap();
        HashMap storyEstimates = Maps.newHashMap();
        if (plan.getWorkItems() != null) {
            for (SchedulingWorkItem schedulingWorkItem : plan.getWorkItems()) {
                if (schedulingWorkItem.getChildIds() == null || !schedulingWorkItem.getChildIds().isEmpty()) continue;
                double directEstimate = WorkItemStatistics.getDirectEstimate(schedulingWorkItem);
                if (schedulingWorkItem.getType().equals(WorkItems.Types.EPIC)) {
                    RmUtils.addToKeyedSets(epicEstimates, schedulingWorkItem, directEstimate);
                    continue;
                }
                if (!schedulingWorkItem.getType().equals(WorkItems.Types.STORY)) continue;
                RmUtils.addToKeyedSets(storyEstimates, schedulingWorkItem, directEstimate);
            }
        }
        return new WorkItemStatistics(epicEstimates, storyEstimates, WorkItemStatistics.getDependencyCount(plan.getWorkItems()), WorkItemStatistics.getReleaseAssignments(plan.getWorkItems()), WorkItemStatistics.getTeamAssignments(plan.getWorkItems()), WorkItemStatistics.getResourceAssigments(plan.getWorkItems()));
    }

    private static double getDirectEstimate(SchedulingWorkItem item) {
        Collection<SchedulingEstimate> skills;
        double sum = 0.0;
        SchedulingEstimate total = (SchedulingEstimate)item.getTotalEstimate().orNull();
        if (total != null) {
            return WorkItemStatistics.getNullsafeEstimate(total);
        }
        Collection<SchedulingEstimate> stages = item.getStageEstimates();
        if (stages != null) {
            for (SchedulingEstimate stage : stages) {
                sum += WorkItemStatistics.getNullsafeEstimate(stage);
            }
        }
        if ((skills = item.getSkillEstimates()) != null) {
            for (SchedulingEstimate skill : skills) {
                sum += WorkItemStatistics.getNullsafeEstimate(skill);
            }
        }
        return sum;
    }

    private static double getNullsafeEstimate(SchedulingEstimate total) {
        if (total.getEstimate() == null) {
            return 0.0;
        }
        return total.getEstimate();
    }

    private static long getDependencyCount(List<? extends SchedulingWorkItem> workItems) {
        long count = 0L;
        if (workItems != null) {
            for (SchedulingWorkItem schedulingWorkItem : workItems) {
                List<String> prerequisites = schedulingWorkItem.getPrerequisites();
                if (prerequisites == null) continue;
                count += (long)prerequisites.size();
            }
        }
        return count;
    }

    private static long getReleaseAssignments(List<? extends SchedulingWorkItem> workItems) {
        long count = 0L;
        if (workItems != null) {
            for (SchedulingWorkItem schedulingWorkItem : workItems) {
                if (schedulingWorkItem.getReleaseId() == null) continue;
                ++count;
            }
        }
        return count;
    }

    private static long getTeamAssignments(List<? extends SchedulingWorkItem> workItems) {
        long count = 0L;
        if (workItems != null) {
            for (SchedulingWorkItem schedulingWorkItem : workItems) {
                if (schedulingWorkItem.getTeamId() == null || !schedulingWorkItem.getTeamId().isPresent()) continue;
                ++count;
            }
        }
        return count;
    }

    private static long getResourceAssigments(List<? extends SchedulingWorkItem> workItems) {
        long count = 0L;
        if (workItems != null) {
            for (SchedulingWorkItem schedulingWorkItem : workItems) {
                if (schedulingWorkItem.getResourceIds() == null || schedulingWorkItem.getResourceIds().isEmpty()) continue;
                ++count;
            }
        }
        return count;
    }

    long getCntUnstructuredEpics() {
        return this.epicEstimates.size();
    }

    Double getAvgUnstructuredEpicsEstimate() {
        return AnalyticsUtil.avg(this.epicEstimates.values());
    }

    long getCntStories() {
        return this.storyEstimates.size();
    }

    Double getAvgStoriesEstimate() {
        return AnalyticsUtil.avg(this.storyEstimates.values());
    }

    Double getStdDevStoriesEstimate() {
        return AnalyticsUtil.stdDev(this.storyEstimates.values());
    }

    long numberOfDependencies() {
        return this.dependencyCnt;
    }

    long numberOfStrictReleaseAssignments() {
        return this.releaseAssignmentCnt;
    }

    long numberOfStrictTeamAssignment() {
        return this.teamAssignmentCnt;
    }

    long numberOfStrictResourceAssignments() {
        return this.resourceAssignmentCnt;
    }

    Double getStdDevUnstructuredEpicsEstimate() {
        return AnalyticsUtil.stdDev(this.epicEstimates.values());
    }
}

