/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.projects;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.projects.IssueTypeData;
import com.radiantminds.roadmap.common.extensions.projects.ProjectData;
import java.util.List;

public interface ListProjectResult {
    public static final Impl EMPTY = new Impl(Lists.newArrayList(), Lists.newArrayList(), false, false, null, null, null, null, false);

    public List<ProjectData> getProjects();

    public List<IssueTypeData> getIssueTypes();

    public boolean isMoreAvailable();

    public boolean isTimeTrackingEnabled();

    public String getEpicIssueType();

    public String getEpicLinkField();

    public String getEpicLabelField();

    public String getStoryPointsField();

    public boolean isJiraAgileCustomFieldsUnavailable();

    public static class Impl
    implements ListProjectResult {
        private final List<ProjectData> projects;
        private final List<IssueTypeData> issueTypes;
        private final boolean moreAvailable;
        private final boolean timeTrackingEnabled;
        private final String epicIssueType;
        private final String epicLinkField;
        private final String epicLabelField;
        private final String storyPointField;
        private final boolean jiraAgileCustomFieldsUnavailable;

        public Impl(List<ProjectData> projects, List<IssueTypeData> issueTypes, boolean moreAvailable, boolean timeTrackingEnabled, String epicIssueType, String epicLinkField, String epicLabelField, String storyPointField, boolean jiraAgileCustomFieldsUnavailable) {
            this.projects = projects;
            this.issueTypes = issueTypes;
            this.moreAvailable = moreAvailable;
            this.timeTrackingEnabled = timeTrackingEnabled;
            this.epicIssueType = epicIssueType;
            this.epicLinkField = epicLinkField;
            this.epicLabelField = epicLabelField;
            this.storyPointField = storyPointField;
            this.jiraAgileCustomFieldsUnavailable = jiraAgileCustomFieldsUnavailable;
        }

        @Override
        public List<ProjectData> getProjects() {
            return this.projects;
        }

        @Override
        public List<IssueTypeData> getIssueTypes() {
            return this.issueTypes;
        }

        @Override
        public boolean isMoreAvailable() {
            return this.moreAvailable;
        }

        @Override
        public String getEpicIssueType() {
            return this.epicIssueType;
        }

        @Override
        public String getEpicLinkField() {
            return this.epicLinkField;
        }

        @Override
        public String getEpicLabelField() {
            return this.epicLabelField;
        }

        @Override
        public String getStoryPointsField() {
            return this.storyPointField;
        }

        @Override
        public boolean isTimeTrackingEnabled() {
            return this.timeTrackingEnabled;
        }

        @Override
        public boolean isJiraAgileCustomFieldsUnavailable() {
            return this.jiraAgileCustomFieldsUnavailable;
        }
    }
}

