/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.extensionlinks;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.handlers.extensionlinks.AddExtensionLinkRequest;
import com.radiantminds.roadmap.common.handlers.extensionlinks.InvalidLinkException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Pair;

public interface SetExtensionLinksRequest {
    public List<AddExtensionLinkRequest> getLinks();

    public static class Impl
    implements SetExtensionLinksRequest {
        private final List<AddExtensionLinkRequest> links;

        private Impl(List<AddExtensionLinkRequest> links) {
            this.links = links;
        }

        @Override
        public List<AddExtensionLinkRequest> getLinks() {
            return this.links;
        }

        public String toString() {
            return "SetExtensionLinksRequest.Impl{, links=" + this.links + '}';
        }

        public static SetExtensionLinksRequest create(List<Pair<String, String>> links, ProgressConfiguration configuration) throws InvalidLinkException {
            ArrayList requests = Lists.newArrayList();
            for (Pair<String, String> link : links) {
                requests.add(AddExtensionLinkRequest.Impl.create(link.getKey(), link.getValue(), configuration));
            }
            return new Impl(requests);
        }
    }
}

