/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.plans;

import com.radiantminds.roadmap.common.data.entities.plans.WeekdayConfiguration;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="weekdays")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestWeekdayConfiguration
implements WeekdayConfiguration {
    @XmlElement
    Boolean mon;
    @XmlElement
    Boolean tue;
    @XmlElement
    Boolean wed;
    @XmlElement
    Boolean thu;
    @XmlElement
    Boolean fri;
    @XmlElement
    Boolean sat;
    @XmlElement
    Boolean sun;

    private RestWeekdayConfiguration() {
    }

    public static RestWeekdayConfiguration fromWeekdayConfiguration(WeekdayConfiguration config) {
        return RestWeekdayConfiguration.fromInteger(config.toInteger());
    }

    public static RestWeekdayConfiguration fromInteger(Integer config) {
        String flags = Integer.toString(config, 2);
        while (flags.length() < 7) {
            flags = "0" + flags;
        }
        RestWeekdayConfiguration retVal = new RestWeekdayConfiguration();
        retVal.mon = flags.charAt(0) == '1';
        retVal.tue = flags.charAt(1) == '1';
        retVal.wed = flags.charAt(2) == '1';
        retVal.thu = flags.charAt(3) == '1';
        retVal.fri = flags.charAt(4) == '1';
        retVal.sat = flags.charAt(5) == '1';
        retVal.sun = flags.charAt(6) == '1';
        return retVal;
    }

    @Override
    public int toInteger() {
        String intString = "";
        intString = intString + (this.mon != false ? (char)'1' : '0');
        intString = intString + (this.tue != false ? (char)'1' : '0');
        intString = intString + (this.wed != false ? (char)'1' : '0');
        intString = intString + (this.thu != false ? (char)'1' : '0');
        intString = intString + (this.fri != false ? (char)'1' : '0');
        intString = intString + (this.sat != false ? (char)'1' : '0');
        intString = intString + (this.sun != false ? (char)'1' : '0');
        return Integer.parseInt(intString, 2);
    }

    @Override
    public Boolean getMon() {
        return this.mon;
    }

    @Override
    public Boolean getTue() {
        return this.tue;
    }

    @Override
    public Boolean getWed() {
        return this.wed;
    }

    @Override
    public Boolean getThu() {
        return this.thu;
    }

    @Override
    public Boolean getFri() {
        return this.fri;
    }

    @Override
    public Boolean getSat() {
        return this.sat;
    }

    @Override
    public Boolean getSun() {
        return this.sun;
    }

    @Override
    public boolean[] getMondayStartingBooleans() {
        boolean[] workDayArray = new boolean[]{this.getMon(), this.getTue(), this.getWed(), this.getThu(), this.getFri(), this.getSat(), this.getSun()};
        return workDayArray;
    }

    @Override
    public int getWorkingDaysCount() {
        int days = 0;
        if (this.getMon().booleanValue()) {
            ++days;
        }
        if (this.getTue().booleanValue()) {
            ++days;
        }
        if (this.getWed().booleanValue()) {
            ++days;
        }
        if (this.getThu().booleanValue()) {
            ++days;
        }
        if (this.getFri().booleanValue()) {
            ++days;
        }
        if (this.getSat().booleanValue()) {
            ++days;
        }
        if (this.getSun().booleanValue()) {
            ++days;
        }
        return days;
    }
}

