/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling.cap;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.rest.entities.scheduling.cap.RestResourceSkills;
import com.radiantminds.roadmap.common.rest.entities.scheduling.cap.RestTeamSprintCapacity;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.TeamCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.TeamSprintCapacityStatistic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="teamData")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestTeamCapacity {
    @XmlElement
    String id;
    @XmlElement
    Set<RestResourceSkills> resourceSkills;
    @XmlElement
    Set<String> assignableStreams;
    @XmlElement
    List<RestTeamSprintCapacity> sprintCapacities;

    RestTeamCapacity(String id, Set<RestResourceSkills> resourceSkills, Set<String> assignableStreams, List<RestTeamSprintCapacity> intervalCapacities) {
        this.id = id;
        this.resourceSkills = resourceSkills;
        this.assignableStreams = assignableStreams;
        this.sprintCapacities = intervalCapacities;
    }

    private RestTeamCapacity() {
    }

    static RestTeamCapacity create(TeamCapacityStatistic statistic) {
        return new RestTeamCapacity(statistic.getId(), RestTeamCapacity.createResourceSkills(statistic.getResourceSkills()), statistic.getAssignableStreams(), RestTeamCapacity.createIntervalCapacities(statistic.getSprintStatistics()));
    }

    private static List<RestTeamSprintCapacity> createIntervalCapacities(List<TeamSprintCapacityStatistic> statistics) {
        ArrayList restStatistics = Lists.newArrayList();
        for (TeamSprintCapacityStatistic statistic : statistics) {
            restStatistics.add(RestTeamSprintCapacity.create(statistic));
        }
        return restStatistics;
    }

    private static Set<RestResourceSkills> createResourceSkills(Set<IWorkResource> resources) {
        HashSet restEntries = Sets.newHashSet();
        for (IWorkResource resource : resources) {
            restEntries.add(RestResourceSkills.create(resource.getId(), resource.getResourceTypes()));
        }
        return restEntries;
    }
}

