/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.rest.exceptions.ExceptionWrapper;
import com.radiantminds.roadmap.common.rest.exceptions.PluginServerInfoProvider;
import com.radiantminds.roadmap.common.rest.exceptions.ServerInfoProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Provider
@Component
public class RestExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Log LOGGER = Log.with(RestExceptionMapper.class);
    private final ServerInfoProvider serverInfoProvider;
    private final FeatureExtension featureExtension;

    @Autowired
    public RestExceptionMapper(ActiveObjectsUtilities activeObjectsUtilities, FeatureExtension featureExtension) {
        this.serverInfoProvider = new PluginServerInfoProvider(activeObjectsUtilities);
        this.featureExtension = featureExtension;
        LOGGER.debug("Instantiating RestExceptionMapper", new Object[0]);
    }

    public Response toResponse(Exception throwable) {
        if (throwable instanceof WebApplicationException) {
            WebApplicationException ex = (WebApplicationException)throwable;
            LOGGER.error("WebApplicationException: " + throwable.getMessage(), new Object[0]);
            LOGGER.error("\tStatus " + ex.getResponse().getStatus(), new Object[0]);
            for (Map.Entry entry : ex.getResponse().getMetadata().entrySet()) {
                ArrayList stringValues = Lists.newArrayList();
                for (Object o : (List)entry.getValue()) {
                    if (o == null) continue;
                    stringValues.add(String.valueOf(o));
                }
                LOGGER.error("\t" + (String)entry.getKey() + ":\t" + StringUtils.join(stringValues), new Object[0]);
            }
            LOGGER.error("\tEntity: " + ex.getResponse().getEntity(), new Object[0]);
        }
        LOGGER.warn("Sending exception to client.", new Object[0]);
        LOGGER.exception(throwable, Log.LogLevel.WARN);
        Optional serverInfoProviderOptional = Optional.fromNullable((Object)(this.featureExtension.isErrorServerDetailsEnabled() ? this.serverInfoProvider : null));
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ExceptionWrapper.from(throwable, (Optional<ServerInfoProvider>)serverInfoProviderOptional)).build();
    }
}

